<?php

/*
 * This file is part of Chevere.
 *
 * (c) Rodolfo Berrios <rodolfo@chevere.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Chevere\Action\Interfaces;

use Stringable;

/**
 * Describes the component in charge of handling the controller name.
 */
interface ControllerNameInterface extends Stringable
{
    /**
     * @return class-string ControllerInterface
     */
    public function __toString(): string;

    /**
     * Returns a boolean if the object has this class as one of its parents or implements it.
     */
    public function isSubclassOf(string $class): bool;
}
