<?php

/*
 * This file is part of Chevere.
 *
 * (c) Rodolfo Berrios <rodolfo@chevere.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Chevere\Workflow\Interfaces;

/**
 * Describes the component in charge of running the workflow.
 */
interface RunnerInterface
{
    public function run(): RunInterface;

    public function withRun(): self;

    public function withRunJob(string $name): self;
}
