﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['de-ch']={"application":"Rich Text Editor","editor":"WYSIWYG-Editor","editorPanel":"WYSIWYG-Editor-Leiste","common":{"editorHelp":"Drücken Sie ALT 0 für Hilfe","browseServer":"Server durchsuchen","url":"URL","protocol":"Protokoll","upload":"Hochladen","uploadSubmit":"Zum Server senden","image":"Bild","form":"Formular","checkbox":"Kontrollbox","radio":"Optionsfeld","textField":"Textfeld","textarea":"Textfeld","hiddenField":"Verstecktes Feld","button":"Schaltfläche","select":"Auswahlfeld","imageButton":"Bildschaltfläche","notSet":"<nicht festgelegt>","id":"Kennung","name":"Name","langDir":"Schreibrichtung","langDirLtr":"Links nach Rechts (LTR)","langDirRtl":"Rechts nach Links (RTL)","langCode":"Sprachcode","longDescr":"Langbeschreibungs-URL","cssClass":"Formatvorlagenklassen","advisoryTitle":"Titel Beschreibung","cssStyle":"Stil","ok":"OK","cancel":"Abbrechen","close":"Schliessen","preview":"Vorschau","resize":"Grösse ändern","generalTab":"Allgemein","advancedTab":"Erweitert","validateNumberFailed":"Dieser Wert ist keine Nummer.","confirmNewPage":"Alle nicht gespeicherten Änderungen gehen verloren. Sind Sie sicher, die neue Seite zu laden?","confirmCancel":"Einige Optionen wurden geändert. Wollen Sie den Dialog dennoch schliessen?","options":"Optionen","target":"Zielseite","targetNew":"Neues Fenster (_blank)","targetTop":"Oberstes Fenster (_top)","targetSelf":"Gleiches Fenster (_self)","targetParent":"Oberes Fenster (_parent)","langDirLTR":"Links nach Rechts (LNR)","langDirRTL":"Rechts nach Links (RNL)","styles":"Style","cssClasses":"Stylesheet Klasse","width":"Breite","height":"Höhe","align":"Ausrichtung","left":"Links","right":"Rechts","center":"Zentriert","justify":"Blocksatz","alignLeft":"Linksbündig","alignRight":"Rechtsbündig","alignCenter":"Zentriert","alignTop":"Oben","alignMiddle":"Mitte","alignBottom":"Unten","alignNone":"Keine","invalidValue":"Ungültiger Wert.","invalidHeight":"Höhe muss eine Zahl sein.","invalidWidth":"Breite muss eine Zahl sein.","invalidLength":"Wert spezifiziert für \"%1\" Feld muss ein positiver numerischer Wert sein mit oder ohne korrekter HTML-Masseinheit (px oder %).","invalidCssLength":"Wert spezifiziert für \"%1\" Feld muss ein positiver numerischer Wert sein mit oder ohne korrekter CSS-Masseinheit (px, %, in, cm, mm, em, ex, pt oder pc).","invalidHtmlLength":"Wert spezifiziert für \"%1\" Feld muss ein positiver numerischer Wert sein mit oder ohne korrekter HTML-Masseinheit (px oder %).","invalidInlineStyle":"Wert spezifiziert für inline Stilart muss enthalten ein oder mehr Wertepaare mit dem Format \"Name : Wert\" getrennt durch Semikolons.","cssLengthTooltip":"Geben Sie eine Zahl ein für ein Wert in Pixel oder eine Zahl mit einer korrekten CSS-Masseinheit (px, %, in, cm, mm, em, ex, pt oder pc).","unavailable":"%1<span class=\"cke_accessibility\">, nicht verfügbar</span>","keyboard":{"8":"Rücktaste","13":"Eingabe","16":"Umschalt","17":"Strg","18":"Alt","32":"Leertaste","35":"Ende","36":"Pos1","46":"Entfernen","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Befehl"},"keyboardShortcut":"Tastaturkürzel","optionDefault":"Standard"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Alle Rechte vorbehalten.","dlgTitle":"Über CKEditor 4","moreInfo":"Für Informationen über unsere Lizenzbestimmungen besuchen Sie bitte unsere Webseite:"},"basicstyles":{"bold":"Fett","italic":"Kursiv","strike":"Durchgestrichen","subscript":"Tiefgestellt","superscript":"Hochgestellt","underline":"Unterstrichen"},"bidi":{"ltr":"Leserichtung von Links nach Rechts","rtl":"Leserichtung von Rechts nach Links"},"blockquote":{"toolbar":"Zitatblock"},"notification":{"closed":"Benachrichtigung geschlossen."},"toolbar":{"toolbarCollapse":"Werkzeugleiste einklappen","toolbarExpand":"Werkzeugleiste ausklappen","toolbarGroups":{"document":"Dokument","clipboard":"Zwischenablage/Rückgängig","editing":"Editieren","forms":"Formulare","basicstyles":"Grundstile","paragraph":"Absatz","links":"Links","insert":"Einfügen","styles":"Stile","colors":"Farben","tools":"Werkzeuge"},"toolbars":"Editor Werkzeugleisten"},"clipboard":{"copy":"Kopieren","copyError":"Die Sicherheitseinstellungen Ihres Browsers lassen es nicht zu, den Text automatisch zu kopieren. Bitte benutzen Sie die System-Zwischenablage über STRG-C (kopieren).","cut":"Ausschneiden","cutError":"Die Sicherheitseinstellungen Ihres Browsers lassen es nicht zu, den Text automatisch auszuschneiden. Bitte benutzen Sie die System-Zwischenablage über STRG-X (ausschneiden) und STRG-V (einfügen).","paste":"Einfügen","pasteNotification":"Drücken Sie %1 zum Einfügen. Ihr Browser unterstützt nicht das Einfügen über dem Knopf in der Werkzeugleiste oder dem Kontextmenü.","pasteArea":"Einfügebereich","pasteMsg":"Fügen Sie den Inhalt in den unteren Bereich ein und drücken Sie OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatisch","bgColorTitle":"Hintergrundfarbe","colors":{"000":"Schwarz","800000":"Kastanienbraun","8B4513":"Braun","2F4F4F":"Dunkles Schiefergrau","008080":"Blaugrün","000080":"Marineblau","4B0082":"Indigo","696969":"Dunkelgrau","B22222":"Ziegelrot","A52A2A":"Braun","DAA520":"Goldgelb","006400":"Dunkelgrün","40E0D0":"Türkis","0000CD":"Mittelblau","800080":"Lila","808080":"Grau","F00":"Rot","FF8C00":"Dunkelorange","FFD700":"Gold","008000":"Grün","0FF":"Cyan","00F":"Blau","EE82EE":"Violett","A9A9A9":"Dunkelgrau","FFA07A":"Helles Lachsrosa","FFA500":"Orange","FFFF00":"Gelb","00FF00":"Lime","AFEEEE":"Blasstürkis","ADD8E6":"Hellblau","DDA0DD":"Pflaumenblau","D3D3D3":"Hellgrau","FFF0F5":"Lavendel","FAEBD7":"Antik Weiss","FFFFE0":"Hellgelb","F0FFF0":"Honigtau","F0FFFF":"Azurblau","F0F8FF":"Alice Blau","E6E6FA":"Lavendel","FFF":"Weiss","1ABC9C":"Kräftiges Türkis","2ECC71":"Smaragdgrün","3498DB":"Helles Blau","9B59B6":"Amethystblau","4E5F70":"Graublau","F1C40F":"Lebhaftes Gelb","16A085":"Dunkeltürkis","27AE60":"Dunkles Smaragdgrün","2980B9":"Kräftiges Blau","8E44AD":"Dunkelvilolett","2C3E50":"Entsättigtes blau","F39C12":"Orange","E67E22":"Karotte","E74C3C":"Blassrot","ECF0F1":"Glänzendes Silber","95A5A6":"Helles Graublau","DDD":"Hellgrau","D35400":"Kürbisfarben","C0392B":"Kräftiges Rot","BDC3C7":"Silber","7F8C8D":"Graucyan","999":"Dunkelgrau"},"more":"Weitere Farben...","panelTitle":"Farben","textColorTitle":"Textfarbe"},"colordialog":{"clear":"Entfernen","highlight":"Hervorheben","options":"Farboptionen","selected":"Ausgewählte Farbe","title":"Farbe auswählen"},"templates":{"button":"Vorlagen","emptyListMsg":"(Keine Vorlagen definiert)","insertOption":"Aktuelle Inhalte ersetzen","options":"Vorlagenoptionen","selectPromptMsg":"Klicken Sie auf eine Vorlage, um sie im Editor zu öffnen","title":"Inhaltsvorlagen"},"contextmenu":{"options":"Kontextmenüoptionen"},"copyformatting":{"label":"Formatierung kopieren","notification":{"copied":"Formatierung kopiert","applied":"Formatierung angewendet","canceled":"Formatierung abgebrochen","failed":"Formatierung fehlgeschlagen. Sie können Stile nicht anwenden, ohne sie zuerst zu kopieren."}},"div":{"IdInputLabel":"Kennung","advisoryTitleInputLabel":"Tooltip","cssClassInputLabel":"Formatvorlagenklasse","edit":"Div bearbeiten","inlineStyleInputLabel":"Inline Stil","langDirLTRLabel":"Links nach Rechts (LTR)","langDirLabel":"Sprachrichtung","langDirRTLLabel":"Rechts nach Links (RTL)","languageCodeInputLabel":"Sprachcode","remove":"Div entfernen","styleSelectLabel":"Stil","title":"Div-Container erzeugen","toolbar":"Div-Container erzeugen"},"elementspath":{"eleLabel":"Elementepfad","eleTitle":"%1 Element"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Während dem Lesen der Datei ist ein Fehler aufgetreten.","networkError":"Während dem Hochladen der Datei ist ein Netzwerkfehler aufgetreten.","httpError404":"Während dem Hochladen der Datei ist ein HTTP-Fehler aufgetreten (404: Datei nicht gefunden).","httpError403":"Während dem Hochladen der Datei ist ein HTTP-Fehler aufgetreten (403: Verboten).","httpError":"Während dem Hochladen der Datei ist ein HTTP-Fehler aufgetreten (Fehlerstatus: %1).","noUrlError":"Hochlade-URL ist nicht definiert.","responseError":"Falsche Antwort des Servers."},"find":{"find":"Suchen","findOptions":"Suchoptionen","findWhat":"Suche nach:","matchCase":"Gross-/Kleinschreibung beachten","matchCyclic":"Zyklische Suche","matchWord":"Nur ganze Wörter suchen","notFoundMsg":"Der angegebene Text wurde nicht gefunden.","replace":"Ersetzen","replaceAll":"Alle ersetzen","replaceSuccessMsg":"%1 Vorkommen ersetzt.","replaceWith":"Ersetze mit:","title":"Suchen und Ersetzen"},"font":{"fontSize":{"label":"Grösse","voiceLabel":"Schriftgrösse","panelTitle":"Schriftgrösse"},"label":"Schriftart","panelTitle":"Schriftartname","voiceLabel":"Schriftart"},"fakeobjects":{"anchor":"Anker","hiddenfield":"Verstecktes Feld","iframe":"IFrame","unknown":"Unbekanntes Objekt"},"forms":{"button":{"title":"Schaltflächeneigenschaften","text":"Text (Wert)","type":"Typ","typeBtn":"Button","typeSbm":"Absenden","typeRst":"Zurücksetzen"},"checkboxAndRadio":{"checkboxTitle":"Kontrollboxeigenschaften","radioTitle":"Optionsfeldeigenschaften","value":"Wert","selected":"Ausgewählt","required":"Erforderlich"},"form":{"title":"Formulareigenschaften","menu":"Formulareigenschaften","action":"Aktion","method":"Methode","encoding":"Kodierung"},"hidden":{"title":"Versteckte Feldeigenschaften","name":"Name","value":"Wert"},"select":{"title":"Auswahlfeldeigenschaften","selectInfo":"Info auswählen","opAvail":"Verfügbare Optionen","value":"Wert","size":"Grösse","lines":"Linien","chkMulti":"Mehrfachauswahl erlauben","required":"Erforderlich","opText":"Text","opValue":"Wert","btnAdd":"Hinzufügen","btnModify":"Ändern","btnUp":"Hoch","btnDown":"Runter","btnSetValue":"Als ausgewählten Wert festlegen","btnDelete":"Entfernen"},"textarea":{"title":"Textfeldeigenschaften","cols":"Spalten","rows":"Reihen"},"textfield":{"title":"Textfeldeigenschaften","name":"Name","value":"Wert","charWidth":"Zeichenbreite","maxChars":"Max. Zeichen","required":"Erforderlich","type":"Typ","typeText":"Text","typePass":"Passwort","typeEmail":"E-mail","typeSearch":"Suche","typeTel":"Telefonnummer","typeUrl":"URL"}},"format":{"label":"Format","panelTitle":"Absatzformat","tag_address":"Adresse","tag_div":"Normal (DIV)","tag_h1":"Überschrift 1","tag_h2":"Überschrift 2","tag_h3":"Überschrift 3","tag_h4":"Überschrift 4","tag_h5":"Überschrift 5","tag_h6":"Überschrift 6","tag_p":"Normal","tag_pre":"Formatiert"},"horizontalrule":{"toolbar":"Horizontale Linie einfügen"},"iframe":{"border":"Rahmen anzeigen","noUrl":"Bitte geben Sie die IFrame-URL an","scrolling":"Rollbalken anzeigen","title":"IFrame-Eigenschaften","toolbar":"IFrame","tabindex":"Aus Tab-Reihenfolge entfernen"},"image":{"alt":"Alternativer Text","border":"Rahmen","btnUpload":"Zum Server senden","button2Img":"Möchten Sie die ausgewählte Bildschaltfläche in ein einfaches Bild umwandeln?","hSpace":"Horizontal-Abstand","img2Button":"Möchten Sie das ausgewählte Bild in eine Bildschaltfläche umwandeln?","infoTab":"Bildinfo","linkTab":"Link","lockRatio":"Grössenverhältnis beibehalten","menu":"Bildeigenschaften","resetSize":"Grösse zurücksetzen","title":"Bildeigenschaften","titleButton":"Bildschaltflächeneigenschaften","upload":"Hochladen","urlMissing":"Bildquellen-URL fehlt.","vSpace":"Vertikal-Abstand","validateBorder":"Rahmen muss eine ganze Zahl sein.","validateHSpace":"Horizontal-Abstand muss eine ganze Zahl sein.","validateVSpace":"Vertikal-Abstand muss eine ganze Zahl sein."},"indent":{"indent":"Einzug vergrössern","outdent":"Einzug verkleinern"},"smiley":{"options":"Smiley-Optionen","title":"Smiley auswählen","toolbar":"Smiley"},"language":{"button":"Sprache festlegen","remove":"Sprache entfernen"},"link":{"acccessKey":"Zugriffstaste","advanced":"Erweitert","advisoryContentType":"Inhaltstyp","advisoryTitle":"Titel Beschreibung","anchor":{"toolbar":"Anker","menu":"Anker bearbeiten","title":"Ankereigenschaften","name":"Ankername","errorName":"Bitte geben Sie den Namen des Ankers ein","errorWhitespace":"Anchor name cannot contain space characters","remove":"Anker entfernen"},"anchorId":"Nach Elementkennung","anchorName":"Nach Ankername","charset":"Verknüpfter Ressourcenzeichensatz","cssClasses":"Formatvorlagenklasse","download":"Herunterladen erzwingen","displayText":"Anzeigetext","emailAddress":"E-Mail-Adresse","emailBody":"Nachrichtentext","emailSubject":"Betreffzeile","id":"Kennung","info":"Linkinfo","langCode":"Sprachcode","langDir":"Schreibrichtung","langDirLTR":"Links nach Rechts (LTR)","langDirRTL":"Rechts nach Links (RTL)","menu":"Link bearbeiten","name":"Name","noAnchors":"(Keine Anker im Dokument vorhanden)","noEmail":"Bitte geben Sie E-Mail-Adresse an","noUrl":"Bitte geben Sie die Link-URL an","noTel":"Bitte geben Sie die Telefonnummer ein","other":"<andere>","phoneNumber":"Telefonnummer","popupDependent":"Abhängig (Netscape)","popupFeatures":"Pop-up Fenstereigenschaften","popupFullScreen":"Vollbild (IE)","popupLeft":"Linke Position","popupLocationBar":"Adressleiste","popupMenuBar":"Menüleiste","popupResizable":"Grösse änderbar","popupScrollBars":"Rollbalken","popupStatusBar":"Statusleiste","popupToolbar":"Werkzeugleiste","popupTop":"Obere Position","rel":"Beziehung","selectAnchor":"Anker auswählen","styles":"Style","tabIndex":"Tab-Index","target":"Zielseite","targetFrame":"<Frame>","targetFrameName":"Ziel-Fenster-Name","targetPopup":"<Pop-up Fenster>","targetPopupName":"Pop-up Fenster-Name","title":"Link","toAnchor":"Anker in dieser Seite","toEmail":"E-Mail","toUrl":"URL","toPhone":"Telefon","toolbar":"Link einfügen/editieren","type":"Link-Typ","unlink":"Link entfernen","upload":"Hochladen"},"list":{"bulletedlist":"Liste","numberedlist":"Nummerierte Liste einfügen/entfernen"},"liststyle":{"bulletedTitle":"Aufzählungslisteneigenschaften","circle":"Ring","decimal":"Dezimal (1, 2, 3, etc.)","disc":"Kreis","lowerAlpha":"Klein Alpha (a, b, c, d, e, usw.)","lowerRoman":"Klein römisch (i, ii, iii, iv, v, usw.)","none":"Keine","notset":"<nicht festgelegt>","numberedTitle":"Nummerierte Listeneigenschaften","square":"Quadrat","start":"Start","type":"Typ","upperAlpha":"Gross alpha (A, B, C, D, E, etc.)","upperRoman":"Gross römisch (I, II, III, IV, V, usw.)","validateStartNumber":"Listenstartnummer muss eine ganze Zahl sein."},"magicline":{"title":"Absatz hier einfügen"},"maximize":{"maximize":"Maximieren","minimize":"Minimieren"},"newpage":{"toolbar":"Neue Seite"},"pagebreak":{"alt":"Seitenumbruch","toolbar":"Seitenumbruch zum Drucken einfügen"},"pastetext":{"button":"Als Klartext einfügen","pasteNotification":"Drücken Sie %1 zum Einfügen. Ihr Browser unterstützt nicht das Einfügen über dem Knopf in der Werkzeugleiste oder dem Kontextmenü.","title":"Als Klartext einfügen"},"pastefromword":{"confirmCleanup":"Der Text, den Sie einfügen möchten, scheint aus MS-Word kopiert zu sein. Möchten Sie ihn zuvor bereinigen lassen?","error":"Aufgrund eines internen Fehlers war es nicht möglich, die eingefügten Daten zu bereinigen","title":"Aus Word einfügen","toolbar":"Aus Word einfügen"},"preview":{"preview":"Vorschau"},"print":{"toolbar":"Drucken"},"removeformat":{"toolbar":"Formatierung entfernen"},"save":{"toolbar":"Speichern"},"selectall":{"toolbar":"Alles auswählen"},"showblocks":{"toolbar":"Blöcke anzeigen"},"sourcearea":{"toolbar":"Quellcode"},"specialchar":{"options":"Sonderzeichenoptionen","title":"Sonderzeichen auswählen","toolbar":"Sonderzeichen einfügen"},"scayt":{"btn_about":"About SCAYT","btn_dictionaries":"Dictionaries","btn_disable":"Disable SCAYT","btn_enable":"Enable SCAYT","btn_langs":"Languages","btn_options":"Options","text_title":"Spell Check As You Type"},"stylescombo":{"label":"Stil","panelTitle":"Formatierungsstile","panelTitle1":"Blockstile","panelTitle2":"Inline Stilart","panelTitle3":"Objektstile"},"table":{"border":"Rahmengrösse","caption":"Überschrift","cell":{"menu":"Zelle","insertBefore":"Zelle davor einfügen","insertAfter":"Zelle danach einfügen","deleteCell":"Zelle löschen","merge":"Zellen verbinden","mergeRight":"Nach rechts verbinden","mergeDown":"Nach unten verbinden","splitHorizontal":"Zelle horizontal teilen","splitVertical":"Zelle vertikal teilen","title":"Zelleneigenschaften","cellType":"Zellart","rowSpan":"Anzahl Zeilen verbinden","colSpan":"Anzahl Spalten verbinden","wordWrap":"Zeilenumbruch","hAlign":"Horizontale Ausrichtung","vAlign":"Vertikale Ausrichtung","alignBaseline":"Grundlinie","bgColor":"Hintergrundfarbe","borderColor":"Rahmenfarbe","data":"Daten","header":"Überschrift","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Ja","no":"Nein","invalidWidth":"Zellenbreite muss eine Zahl sein.","invalidHeight":"Zellenhöhe muss eine Zahl sein.","invalidRowSpan":"\"Anzahl Zeilen verbinden\" muss eine Ganzzahl sein.","invalidColSpan":"\"Anzahl Spalten verbinden\" muss eine Ganzzahl sein.","chooseColor":"Wählen"},"cellPad":"Zellenabstand innen","cellSpace":"Zellenabstand aussen","column":{"menu":"Spalte","insertBefore":"Spalte links davor einfügen","insertAfter":"Spalte rechts danach einfügen","deleteColumn":"Spalte löschen"},"columns":"Spalte","deleteTable":"Tabelle löschen","headers":"Kopfzeile","headersBoth":"Beide","headersColumn":"Erste Spalte","headersNone":"Keine","headersRow":"Erste Zeile","heightUnit":"Höheneinheit","invalidBorder":"Die Rahmenbreite muss eine Zahl sein.","invalidCellPadding":"Der Zellenabstand innen muss eine positive Zahl sein.","invalidCellSpacing":"Der Zellenabstand aussen muss eine positive Zahl sein.","invalidCols":"Die Anzahl der Spalten muss grösser als 0 sein..","invalidHeight":"Die Tabellenbreite muss eine Zahl sein.","invalidRows":"Die Anzahl der Zeilen muss grösser als 0 sein.","invalidWidth":"Die Tabellenbreite muss eine Zahl sein.","menu":"Tabellen-Eigenschaften","row":{"menu":"Zeile","insertBefore":"Zeile oberhalb einfügen","insertAfter":"Zeile unterhalb einfügen","deleteRow":"Zeile entfernen"},"rows":"Zeile","summary":"Inhaltsübersicht","title":"Tabellen-Eigenschaften","toolbar":"Tabelle","widthPc":"%","widthPx":"Pixel","widthUnit":"Breiteneinheit"},"undo":{"redo":"Wiederherstellen","undo":"Rückgängig"},"widget":{"move":"Zum Verschieben anwählen und ziehen","label":"%1 Steuerelement"},"uploadwidget":{"abort":"Hochladen durch den Benutzer abgebrochen.","doneOne":"Datei erfolgreich hochgeladen.","doneMany":"%1 Dateien erfolgreich hochgeladen.","uploadOne":"Datei wird hochgeladen ({percentage}%)...","uploadMany":"Dateien werden hochgeladen, {current} von {max} fertig ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Source","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Emoji suchen…","searchLabel":"Das Eingabefeld ermöglicht die Suche nach Emojis.","navigationLabel":"Navigieren Sie zwischen den Emoji-Kategorien.","title":"Emoji-Liste","groups":{"people":"Personen","nature":"Natur und Tiere","food":"Essen und Getränke","travel":"Reisen und Orte","activities":"Aktivitäten","objects":"Objekte","symbols":"Symbole","flags":"Flaggen"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Quellcode","title":"Quellcode"}};