﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['fr']={"application":"Rich Text Editor","editor":"Éditeur de texte enrichi","editorPanel":"Tableau de bord de l'éditeur de texte enrichi","common":{"editorHelp":"Utilisez le raccourci Alt-0 pour obtenir de l'aide","browseServer":"Parcourir le serveur","url":"URL","protocol":"Protocole","upload":"Télécharger","uploadSubmit":"Envoyer sur le serveur","image":"Image","form":"Formulaire","checkbox":"Case à cocher","radio":"Bouton radio","textField":"Champ texte","textarea":"Zone de texte","hiddenField":"Champ invisible","button":"Bouton","select":"Liste déroulante","imageButton":"Bouton avec image","notSet":"<indéfini>","id":"ID","name":"Nom","langDir":"Sens d'écriture","langDirLtr":"Gauche à droite (LTR)","langDirRtl":"Droite à gauche (RTL)","langCode":"Code de langue","longDescr":"URL de description longue","cssClass":"Classes de style","advisoryTitle":"Infobulle","cssStyle":"Style","ok":"OK","cancel":"Annuler","close":"Fermer","preview":"Aperçu","resize":"Redimensionner","generalTab":"Général","advancedTab":"Avancé","validateNumberFailed":"Cette valeur n'est pas un nombre.","confirmNewPage":"Les changements non sauvegardés seront perdus. Êtes-vous sûr de vouloir charger une nouvelle page ?","confirmCancel":"Certaines options ont été modifiées. Êtes-vous sûr de vouloir fermer ?","options":"Options","target":"Cible","targetNew":"Nouvelle fenêtre (_blank)","targetTop":"Fenêtre supérieure (_top)","targetSelf":"Même fenêtre (_self)","targetParent":"Fenêtre parent (_parent)","langDirLTR":"Gauche à droite (LTR)","langDirRTL":"Droite à gauche (RTL)","styles":"Style","cssClasses":"Classes de style","width":"Largeur","height":"Hauteur","align":"Alignement","left":"Gauche","right":"Droite","center":"Centrer","justify":"Justifier","alignLeft":"Aligner à gauche","alignRight":"Aligner à droite","alignCenter":"Aligner au centre","alignTop":"Haut","alignMiddle":"Milieu","alignBottom":"Bas","alignNone":"Aucun","invalidValue":"Valeur invalide.","invalidHeight":"La hauteur doit être un nombre.","invalidWidth":"La largeur doit être un nombre.","invalidLength":"La valeur de \"%1\" doit être un nombre positif avec ou sans unité de mesure (%2).","invalidCssLength":"La valeur spécifiée pour le champ « %1 » doit être un nombre positif avec ou sans unité de mesure CSS valide (px, %, in, cm, mm, em, ex, pt, ou pc).","invalidHtmlLength":"La valeur spécifiée pour le champ « %1 » doit être un nombre positif avec ou sans unité de mesure HTML valide (px ou %).","invalidInlineStyle":"La valeur spécifiée pour le style en ligne doit être composée d'un ou plusieurs couples au format « nom : valeur », séparés par des points-virgules.","cssLengthTooltip":"Entrer un nombre pour une valeur en pixels ou un nombre avec une unité de mesure CSS valide (px, %, in, cm, mm, em, ex, pt, ou pc).","unavailable":"%1<span class=\"cke_accessibility\">, indisponible</span>","keyboard":{"8":"Retour arrière","13":"Entrée","16":"Majuscule","17":"Ctrl","18":"Alt","32":"Espace","35":"Fin","36":"Origine","46":"Supprimer","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Commande"},"keyboardShortcut":"Raccourci clavier","optionDefault":"Par défaut"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Tous droits réservés.","dlgTitle":"À propos de CKEditor 4","moreInfo":"Pour les informations de licence, veuillez visiter notre site web :"},"basicstyles":{"bold":"Gras","italic":"Italique","strike":"Barré","subscript":"Indice","superscript":"Exposant","underline":"Souligné"},"bidi":{"ltr":"Direction du texte de la gauche vers la droite","rtl":"Direction du texte de la droite vers la gauche"},"blockquote":{"toolbar":"Citation"},"notification":{"closed":"Notification fermée."},"toolbar":{"toolbarCollapse":"Enrouler la barre d'outils","toolbarExpand":"Dérouler la barre d'outils","toolbarGroups":{"document":"Document","clipboard":"Presse-papier/Défaire","editing":"Édition","forms":"Formulaires","basicstyles":"Styles de base","paragraph":"Paragraphe","links":"Liens","insert":"Insérer","styles":"Styles","colors":"Couleurs","tools":"Outils"},"toolbars":"Barres d'outils de l'éditeur"},"clipboard":{"copy":"Copier","copyError":"Les paramètres de sécurité de votre navigateur n'autorisent pas l'éditeur à exécuter automatiquement l'opération « Copier ». Veuillez utiliser le raccourci clavier à cet effet (Ctrl/Cmd+C).","cut":"Couper","cutError":"Les paramètres de sécurité de votre navigateur n'autorisent pas l'éditeur à exécuter automatiquement l'opération « Couper ». Veuillez utiliser le raccourci clavier à cet effet (Ctrl/Cmd+X).","paste":"Coller","pasteNotification":"Utilisez le raccourci %1 pour coller. Votre navigateur n'accepte pas de coller à l'aide du bouton ou du menu contextuel.","pasteArea":"Coller la zone","pasteMsg":"Collez votre contenu dans la zone de saisie ci-dessous et cliquez OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatique","bgColorTitle":"Couleur d'arrière-plan","colors":{"000":"Noir","800000":"Marron","8B4513":"Brun de selle","2F4F4F":"Gris sombre d'ardoise","008080":"Canard","000080":"Bleu marine","4B0082":"Indigo","696969":"Gris foncé","B22222":"Rouge brique","A52A2A":"Brun","DAA520":"Or terni","006400":"Vert foncé","40E0D0":"Turquoise","0000CD":"Bleu royal","800080":"Violet","808080":"Gris","F00":"Rouge","FF8C00":"Orange foncé","FFD700":"Or","008000":"Vert","0FF":"Cyan","00F":"Bleu","EE82EE":"Violet","A9A9A9":"Gris tamisé","FFA07A":"Saumon clair","FFA500":"Orange","FFFF00":"Jaune","00FF00":"Lime","AFEEEE":"Turquoise clair","ADD8E6":"Bleu clair","DDA0DD":"Prune","D3D3D3":"Gris clair","FFF0F5":"Fard lavande","FAEBD7":"Blanc antique","FFFFE0":"Jaune clair","F0FFF0":"Vert rosée","F0FFFF":"Azur","F0F8FF":"Bleu Alice","E6E6FA":"Lavande","FFF":"Blanc","1ABC9C":"Cyan dur","2ECC71":"Émeraude","3498DB":"Bleu brillant","9B59B6":"Améthyste","4E5F70":"Bleu-gris","F1C40F":"Jaune vif","16A085":"Cyan foncé","27AE60":"Émeraude foncée","2980B9":"Bleu dur","8E44AD":"Violet foncé","2C3E50":"Bleu désaturé","F39C12":"Orange","E67E22":"Carotte","E74C3C":"Rouge pâle","ECF0F1":"Argent brillant","95A5A6":"Cyan-gris clair","DDD":"Gris clair","D35400":"Citrouille","C0392B":"Rouge dur","BDC3C7":"Argent","7F8C8D":"Cyan-gris","999":"Gris foncé"},"more":"Plus de couleurs...","panelTitle":"Couleurs","textColorTitle":"Couleur du texte"},"colordialog":{"clear":"Effacer","highlight":"Pointée","options":"Options de couleur","selected":"Couleur choisie","title":"Sélectionner une couleur"},"templates":{"button":"Modèles","emptyListMsg":"(Aucun modèle disponible)","insertOption":"Remplacer le contenu actuel","options":"Options des modèles","selectPromptMsg":"Veuillez sélectionner le modèle à ouvrir dans l'éditeur","title":"Contenu des modèles"},"contextmenu":{"options":"Options du menu contextuel"},"copyformatting":{"label":"Copier le formatage","notification":{"copied":"Formatage copié","applied":"Formatage appliqué","canceled":"Formatage supprimé","failed":"Échec du formatage. Vous devez d'abord copier des styles pour pouvoir les appliquer."}},"div":{"IdInputLabel":"ID","advisoryTitleInputLabel":"Infobulle","cssClassInputLabel":"Classes de style","edit":"Modifier la division","inlineStyleInputLabel":"Style en ligne","langDirLTRLabel":"Gauche à droite (LTR)","langDirLabel":"Sens d'écriture","langDirRTLLabel":"Droite à gauche (RTL)","languageCodeInputLabel":"Code de langue","remove":"Enlever la division","styleSelectLabel":"Style","title":"Créer une division","toolbar":"Créer une division"},"elementspath":{"eleLabel":"Chemin des éléments","eleTitle":"Élément %1"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Une erreur est survenue lors de la lecture du fichier.","networkError":"Une erreur réseau est survenue lors du téléversement du fichier.","httpError404":"Une erreur HTTP est survenue durant le téléversement du fichier (404 : fichier non trouvé).","httpError403":"Une erreur HTTP est survenue durant le téléversement du fichier (403 : accès refusé).","httpError":"Une erreur HTTP est survenue durant le téléversement du fichier (erreur : %1).","noUrlError":"L'URL de téléversement n'est pas spécifiée.","responseError":"Réponse du serveur incorrecte."},"find":{"find":"Rechercher","findOptions":"Options de recherche","findWhat":"Rechercher :","matchCase":"Respecter la casse","matchCyclic":"Boucler","matchWord":"Mot entier uniquement","notFoundMsg":"Le texte spécifié ne peut être trouvé.","replace":"Remplacer","replaceAll":"Remplacer tout","replaceSuccessMsg":"%1 occurrence(s) remplacée(s).","replaceWith":"Remplacer par : ","title":"Rechercher et remplacer"},"font":{"fontSize":{"label":"Taille","voiceLabel":"Taille de police","panelTitle":"Taille de police"},"label":"Police","panelTitle":"Style de police","voiceLabel":"Police"},"fakeobjects":{"anchor":"Ancre","hiddenfield":"Champ invisible","iframe":"Cadre de contenu incorporé","unknown":"Objet inconnu"},"forms":{"button":{"title":"Propriétés du bouton","text":"Texte","type":"Type","typeBtn":"Bouton","typeSbm":"Validation","typeRst":"Remise à zéro"},"checkboxAndRadio":{"checkboxTitle":"Propriétés de la case à cocher","radioTitle":"Propriétés du bouton radio","value":"Valeur","selected":"Sélectionné","required":"Requis"},"form":{"title":"Propriétés du formulaire","menu":"Propriétés du formulaire","action":"Action","method":"Méthode","encoding":"Encodage"},"hidden":{"title":"Propriétés du champ invisible","name":"Nom","value":"Valeur"},"select":{"title":"Propriétés du menu déroulant","selectInfo":"Informations sur le menu déroulant","opAvail":"Options disponibles","value":"Valeur","size":"Taille","lines":"lignes","chkMulti":"Permettre les sélections multiples","required":"Requis","opText":"Texte","opValue":"Valeur","btnAdd":"Ajouter","btnModify":"Modifier","btnUp":"Haut","btnDown":"Bas","btnSetValue":"Définir comme valeur sélectionnée","btnDelete":"Supprimer"},"textarea":{"title":"Propriétés de la zone de texte","cols":"Colonnes","rows":"Lignes"},"textfield":{"title":"Propriétés du champ texte","name":"Nom","value":"Valeur","charWidth":"Largeur des caractères","maxChars":"Nombre maximum de caractères","required":"Requis","type":"Type","typeText":"Texte","typePass":"Mot de passe","typeEmail":"Courriel","typeSearch":"Rechercher","typeTel":"Numéro de téléphone","typeUrl":"URL"}},"format":{"label":"Format","panelTitle":"Format de paragraphe","tag_address":"Adresse","tag_div":"Division","tag_h1":"Titre 1","tag_h2":"Titre 2","tag_h3":"Titre 3","tag_h4":"Titre 4","tag_h5":"Titre 5","tag_h6":"Titre 6","tag_p":"Normal","tag_pre":"Préformaté"},"horizontalrule":{"toolbar":"Ligne horizontale"},"iframe":{"border":"Afficher la bordure du cadre","noUrl":"Veuillez entrer l'URL du contenu du cadre","scrolling":"Activer les barres de défilement","title":"Propriétés du cadre de contenu incorporé","toolbar":"Cadre de contenu incorporé","tabindex":"Supprimer de tabindex"},"image":{"alt":"Texte alternatif","border":"Bordure","btnUpload":"Envoyer sur le serveur","button2Img":"Voulez-vous transformer le bouton avec image sélectionné en simple image ?","hSpace":"Espacement horizontal","img2Button":"Voulez-vous transformer l'image sélectionnée en bouton avec image ?","infoTab":"Informations sur l'image","linkTab":"Lien","lockRatio":"Conserver les proportions","menu":"Propriétés de l'image","resetSize":"Réinitialiser la taille","title":"Propriétés de l'image","titleButton":"Propriétés du bouton avec image","upload":"Téléverser","urlMissing":"L'URL source de l'image est manquante.","vSpace":"Espacement vertical","validateBorder":"La bordure doit être un nombre entier.","validateHSpace":"L'espacement horizontal doit être un nombre entier.","validateVSpace":"L'espacement vertical doit être un nombre entier."},"indent":{"indent":"Augmenter le retrait","outdent":"Diminuer le retrait"},"smiley":{"options":"Options des frimousses","title":"Insérer une frimousse","toolbar":"Frimousse"},"language":{"button":"Définir la langue","remove":"Supprimer la langue"},"link":{"acccessKey":"Touche d'accessibilité","advanced":"Avancé","advisoryContentType":"Type de contenu (indicatif)","advisoryTitle":"Infobulle","anchor":{"toolbar":"Ancre","menu":"Modifier l'ancre","title":"Propriétés de l'ancre","name":"Nom de l'ancre","errorName":"Veuillez entrer le nom de l'ancre.","errorWhitespace":"Anchor name cannot contain space characters","remove":"Supprimer l'ancre"},"anchorId":"Par ID d'élément","anchorName":"Par nom d'ancre","charset":"Encodage de la ressource liée","cssClasses":"Classes de style","download":"Forcer le téléchargement","displayText":"Afficher le texte","emailAddress":"Adresse électronique","emailBody":"Corps du message","emailSubject":"Sujet du message","id":"ID","info":"Informations sur le lien","langCode":"Code de langue","langDir":"Sens d'écriture","langDirLTR":"Gauche à droite","langDirRTL":"Droite à gauche (RTL)","menu":"Modifier le lien","name":"Nom","noAnchors":"(Aucune ancre disponible dans ce document)","noEmail":"Veuillez entrer l'adresse électronique","noUrl":"Veuillez entrer l'URL du lien","noTel":"Veuillez entrer le numéro de téléphone","other":"<autre>","phoneNumber":"Numéro de téléphone","popupDependent":"Dépendante (Netscape)","popupFeatures":"Caractéristiques de la fenêtre surgissante","popupFullScreen":"Plein écran (IE)","popupLeft":"À gauche","popupLocationBar":"Barre d'adresse","popupMenuBar":"Barre de menu","popupResizable":"Redimensionnable","popupScrollBars":"Barres de défilement","popupStatusBar":"Barre d'état","popupToolbar":"Barre d'outils","popupTop":"En haut","rel":"Relation","selectAnchor":"Sélectionner une ancre","styles":"Style","tabIndex":"Indice de tabulation","target":"Cible","targetFrame":"<cadre>","targetFrameName":"Nom du cadre affecté","targetPopup":"<fenêtre surgissante>","targetPopupName":"Nom de la fenêtre surgissante","title":"Lien","toAnchor":"Ancre","toEmail":"Courriel","toUrl":"URL","toPhone":"Téléphone","toolbar":"Lien","type":"Type de lien","unlink":"Supprimer le lien","upload":"Téléverser"},"list":{"bulletedlist":"Insérer/Supprimer une liste à puces","numberedlist":"Insérer/Supprimer une liste numérotée"},"liststyle":{"bulletedTitle":"Propriétés de la liste à puces","circle":"Cercle","decimal":"Décimal (1, 2, 3, etc.)","disc":"Disque","lowerAlpha":"Lettres minuscules (a, b, c, d, e, etc.)","lowerRoman":"Chiffres romains minuscules (i, ii, iii, iv, v, etc.)","none":"Aucun","notset":"<indéfini>","numberedTitle":"Propriétés de la liste numérotée","square":"Carré","start":"Début","type":"Type","upperAlpha":"Lettres majuscules (A, B, C, D, E, etc.)","upperRoman":"Chiffres romains majuscules (I, II, III, IV, V, etc.)","validateStartNumber":"Le premier élément de la liste doit être un nombre entier."},"magicline":{"title":"Insérer un paragraphe ici"},"maximize":{"maximize":"Agrandir","minimize":"Réduire"},"newpage":{"toolbar":"Nouvelle page"},"pagebreak":{"alt":"Saut de page","toolbar":"Insérer un saut de page pour l'impression"},"pastetext":{"button":"Coller comme texte brut","pasteNotification":"Utilisez le raccourci %1 pour coller. Votre navigateur n'accepte pas de coller à l'aide du bouton ou du menu contextuel.","title":"Coller comme texte brut"},"pastefromword":{"confirmCleanup":"Le texte à coller semble provenir de Word. Désirez-vous le nettoyer avant de coller ?","error":"Les données collées n'ont pas pu être nettoyées à cause d'une erreur interne","title":"Coller depuis Word","toolbar":"Coller depuis Word"},"preview":{"preview":"Aperçu"},"print":{"toolbar":"Imprimer"},"removeformat":{"toolbar":"Supprimer la mise en forme"},"save":{"toolbar":"Enregistrer"},"selectall":{"toolbar":"Tout sélectionner"},"showblocks":{"toolbar":"Afficher les blocs"},"sourcearea":{"toolbar":"Source"},"specialchar":{"options":"Options des caractères spéciaux","title":"Sélectionner un caractère","toolbar":"Insérer un caractère spécial"},"scayt":{"btn_about":"A propos de SCAYT","btn_dictionaries":"Dictionnaires","btn_disable":"Désactiver SCAYT","btn_enable":"Activer SCAYT","btn_langs":"Langues","btn_options":"Options","text_title":"Vérification de l'Orthographe en Cours de Frappe (SCAYT)"},"stylescombo":{"label":"Styles","panelTitle":"Styles de mise en forme","panelTitle1":"Styles de bloc","panelTitle2":"Styles en ligne","panelTitle3":"Styles d'objet"},"table":{"border":"Taille de la bordure","caption":"Titre du tableau","cell":{"menu":"Cellule","insertBefore":"Insérer une cellule avant","insertAfter":"Insérer une cellule après","deleteCell":"Supprimer les cellules","merge":"Fusionner les cellules","mergeRight":"Fusionner vers la droite","mergeDown":"Fusionner vers le bas","splitHorizontal":"Scinder la cellule horizontalement","splitVertical":"Scinder la cellule verticalement","title":"Propriétés de la cellule","cellType":"Type de cellule","rowSpan":"Lignes occupées","colSpan":"Colonnes occupées","wordWrap":"Césure","hAlign":"Alignement horizontal","vAlign":"Alignement vertical","alignBaseline":"Ligne de base","bgColor":"Couleur d'arrière-plan","borderColor":"Couleur de bordure","data":"Données","header":"En-tête","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Oui","no":"Non","invalidWidth":"La largeur de la cellule doit être un nombre.","invalidHeight":"La hauteur de la cellule doit être un nombre.","invalidRowSpan":"Le nombre de colonnes occupées doit être un nombre entier.","invalidColSpan":"Le nombre de colonnes occupées doit être un nombre entier.","chooseColor":"Choisir"},"cellPad":"Marge interne des cellules","cellSpace":"Espacement entre les cellules","column":{"menu":"Colonne","insertBefore":"Insérer une colonne avant","insertAfter":"Insérer une colonne après","deleteColumn":"Supprimer les colonnes"},"columns":"Colonnes","deleteTable":"Supprimer le tableau","headers":"En-têtes","headersBoth":"Les deux","headersColumn":"Première colonne","headersNone":"Aucun","headersRow":"Première ligne","heightUnit":"unité de hauteur","invalidBorder":"La taille de la bordure doit être un nombre.","invalidCellPadding":"La marge interne des cellules doit être un nombre positif.","invalidCellSpacing":"L'espacement entre les cellules doit être un nombre positif.","invalidCols":"Le nombre de colonnes doit être supérieur à 0.","invalidHeight":"La hauteur du tableau doit être un nombre.","invalidRows":"Le nombre de lignes doit être supérieur à 0.","invalidWidth":"La largeur du tableau doit être un nombre.","menu":"Propriétés du tableau","row":{"menu":"Ligne","insertBefore":"Insérer une ligne avant","insertAfter":"Insérer une ligne après","deleteRow":"Supprimer les lignes"},"rows":"Lignes","summary":"Résumé (description)","title":"Propriétés du tableau","toolbar":"Tableau","widthPc":"pour cent","widthPx":"pixels","widthUnit":"unité de largeur"},"undo":{"redo":"Rétablir","undo":"Annuler"},"widget":{"move":"Cliquer et glisser pour déplacer","label":"Élément %1"},"uploadwidget":{"abort":"Téléversement interrompu par l'utilisateur.","doneOne":"Fichier téléversé avec succès.","doneMany":"%1 fichiers téléversés avec succès.","uploadOne":"Téléversement du fichier en cours ({percentage} %)…","uploadMany":"Téléversement des fichiers en cours, {current} sur {max} effectués ({percentage} %)…"},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Source","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Chercher un émoticône","searchLabel":"Champ de saisie chargé de rechercher et de filtrer les émoticônes à l'intérieur du panneau","navigationLabel":"Catégorisation des sections d'émoticône","title":"Liste des émoticônes","groups":{"people":"Personnes","nature":"Nature et animal","food":"Nourriture et boisson","travel":"Lieu et voyage","activities":"Activités","objects":"Objets","symbols":"Symboles","flags":"Drapeaux"}},"html5video":{"button":"Insérer un lecteur video HTML5","title":"HTML5 video","infoLabel":"Informations video","allowed":"Extensions de fichiers autorisées: MP4, WebM, Ogv","urlMissing":"URL de la source video manquante. Veuillez la renseigner.","videoProperties":"Propriétés Video","upload":"Télécharger","btnUpload":"Envoyer vers le serveur","advanced":"Avancé","autoplay":"Jouer automatiquement ?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Oui","no":"Non","controls":"Afficher les contrôles ?","loop":"Loop?","responsive":"Responsive width","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Source","title":"Source"}};