<?php

return [
	/*
	|--------------------------------------------------------------------------
	| Default Hash Driver
	|--------------------------------------------------------------------------
	|
	| This option controls the default hash driver that will be used to hash
	| passwords for your application. By default, the bcrypt algorithm is
	| used; however, you remain free to modify this option if you wish.
	|
	| Supported: "bcrypt", "argon", "argon2id"
	|
	*/

	'driver' => env('HASHING_ALGORITHM', 'bcrypt'),

	/*
	|--------------------------------------------------------------------------
	| Bcrypt Options
	|--------------------------------------------------------------------------
	|
	| Here you may specify the configuration options that should be used when
	| passwords are hashed using the Bcrypt algorithm. This will allow you
	| to control the amount of time it takes to hash the given password.
	|
	*/

	'bcrypt' => [
		'rounds' => env('BCRYPT_ROUNDS', 10),
	],

	/*
	|--------------------------------------------------------------------------
	| Argon Options
	|--------------------------------------------------------------------------
	|
	| Here you may specify the configuration options that should be used when
	| passwords are hashed using the Argon algorithm. These will allow you
	| to control the amount of time it takes to hash the given password.
	|
	*/

	'argon' => [
		'memory' => env('ARGON_MEMORY', 1024),
		'threads' => env('ARGON_THREADS', 2),
		'time' => env('ARGON_TIME', 2),
	],
];
