
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `osclassified830`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_admin`
--

CREATE TABLE `[[dbprefix]]t_admin` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `s_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_username` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_password` char(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_secret` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_moderator` tinyint(1) NOT NULL DEFAULT '0',
  `s_moderator_access` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `i_login_fails` int(3) DEFAULT '0',
  `dt_login_fail_date` datetime DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`),
  UNIQUE KEY `s_username` (`s_username`),
  UNIQUE KEY `s_email` (`s_email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]t_admin`
--

INSERT INTO `[[dbprefix]]t_admin` VALUES
(1, 'Administrator', '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', NULL, 0, NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_alerts`
--

CREATE TABLE `[[dbprefix]]t_alerts` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `s_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_user_id` int(10) unsigned DEFAULT NULL,
  `s_search` text COLLATE utf8mb4_unicode_ci,
  `s_param` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_sql` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_secret` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_active` tinyint(1) NOT NULL DEFAULT '0',
  `e_type` enum('INSTANT','HOURLY','DAILY','WEEKLY','CUSTOM') COLLATE utf8mb4_unicode_ci NOT NULL,
  `i_num_trigger` int(10) DEFAULT '0',
  `dt_date` datetime DEFAULT NULL,
  `dt_unsub_date` datetime DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_alerts_sent`
--

CREATE TABLE `[[dbprefix]]t_alerts_sent` (
  `d_date` date NOT NULL,
  `i_num_alerts_sent` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`d_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_ban_rule`
--

CREATE TABLE `[[dbprefix]]t_ban_rule` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `s_name` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `s_ip` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `s_email` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `i_hit` int(10) DEFAULT '1',
  `dt_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `dt_expire_date` date DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_category`
--

CREATE TABLE `[[dbprefix]]t_category` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_i_parent_id` int(10) unsigned DEFAULT NULL,
  `i_expiration_days` int(3) unsigned NOT NULL DEFAULT '0',
  `i_position` int(2) unsigned NOT NULL DEFAULT '0',
  `b_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `b_price_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `s_icon` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_color` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_i_parent_id` (`fk_i_parent_id`),
  KEY `i_position` (`i_position`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=96 ;

--
-- Dumping data for table `[[dbprefix]]t_category`
--

INSERT INTO `[[dbprefix]]t_category` VALUES
(1, NULL, 0, 1, 1, 1, NULL, NULL),
(2, NULL, 0, 2, 1, 1, NULL, NULL),
(3, NULL, 0, 3, 1, 1, NULL, NULL),
(4, NULL, 0, 4, 1, 1, NULL, NULL),
(5, NULL, 0, 5, 1, 1, NULL, NULL),
(6, NULL, 0, 6, 1, 1, NULL, NULL),
(7, NULL, 0, 7, 1, 1, NULL, NULL),
(8, NULL, 0, 8, 1, 1, NULL, NULL),
(9, 1, 0, 1, 1, 1, NULL, NULL),
(10, 1, 0, 2, 1, 1, NULL, NULL),
(11, 1, 0, 3, 1, 1, NULL, NULL),
(12, 1, 0, 4, 1, 1, NULL, NULL),
(13, 1, 0, 5, 1, 1, NULL, NULL),
(14, 1, 0, 6, 1, 1, NULL, NULL),
(15, 1, 0, 7, 1, 1, NULL, NULL),
(16, 1, 0, 8, 1, 1, NULL, NULL),
(17, 1, 0, 9, 1, 1, NULL, NULL),
(18, 1, 0, 10, 1, 1, NULL, NULL),
(19, 1, 0, 11, 1, 1, NULL, NULL),
(20, 1, 0, 12, 1, 1, NULL, NULL),
(21, 1, 0, 13, 1, 1, NULL, NULL),
(22, 1, 0, 14, 1, 1, NULL, NULL),
(23, 1, 0, 15, 1, 1, NULL, NULL),
(24, 1, 0, 16, 1, 1, NULL, NULL),
(25, 1, 0, 17, 1, 1, NULL, NULL),
(26, 1, 0, 18, 1, 1, NULL, NULL),
(27, 1, 0, 19, 1, 1, NULL, NULL),
(28, 1, 0, 20, 1, 1, NULL, NULL),
(29, 1, 0, 21, 1, 1, NULL, NULL),
(30, 1, 0, 22, 1, 1, NULL, NULL),
(31, 2, 0, 1, 1, 1, NULL, NULL),
(32, 2, 0, 2, 1, 1, NULL, NULL),
(33, 2, 0, 3, 1, 1, NULL, NULL),
(34, 2, 0, 4, 1, 1, NULL, NULL),
(35, 2, 0, 5, 1, 1, NULL, NULL),
(36, 2, 0, 6, 1, 1, NULL, NULL),
(37, 2, 0, 7, 1, 1, NULL, NULL),
(38, 3, 0, 1, 1, 1, NULL, NULL),
(39, 3, 0, 2, 1, 1, NULL, NULL),
(40, 3, 0, 3, 1, 1, NULL, NULL),
(41, 3, 0, 4, 1, 1, NULL, NULL),
(42, 3, 0, 5, 1, 1, NULL, NULL),
(43, 4, 0, 1, 1, 1, NULL, NULL),
(44, 4, 0, 2, 1, 1, NULL, NULL),
(45, 4, 0, 3, 1, 1, NULL, NULL),
(46, 4, 0, 4, 1, 1, NULL, NULL),
(47, 4, 0, 5, 1, 1, NULL, NULL),
(48, 4, 0, 6, 1, 1, NULL, NULL),
(49, 4, 0, 7, 1, 1, NULL, NULL),
(50, 4, 0, 8, 1, 1, NULL, NULL),
(51, 4, 0, 9, 1, 1, NULL, NULL),
(52, 5, 0, 1, 1, 1, NULL, NULL),
(53, 5, 0, 2, 1, 1, NULL, NULL),
(54, 5, 0, 3, 1, 1, NULL, NULL),
(55, 5, 0, 4, 1, 1, NULL, NULL),
(56, 5, 0, 5, 1, 1, NULL, NULL),
(57, 5, 0, 6, 1, 1, NULL, NULL),
(58, 5, 0, 7, 1, 1, NULL, NULL),
(59, 5, 0, 8, 1, 1, NULL, NULL),
(60, 5, 0, 9, 1, 1, NULL, NULL),
(61, 5, 0, 10, 1, 1, NULL, NULL),
(62, 5, 0, 11, 1, 1, NULL, NULL),
(63, 6, 0, 1, 1, 1, NULL, NULL),
(64, 6, 0, 2, 1, 1, NULL, NULL),
(65, 6, 0, 3, 1, 1, NULL, NULL),
(66, 6, 0, 4, 1, 1, NULL, NULL),
(67, 6, 0, 5, 1, 1, NULL, NULL),
(68, 6, 0, 6, 1, 1, NULL, NULL),
(69, 7, 0, 1, 1, 1, NULL, NULL),
(70, 7, 0, 2, 1, 1, NULL, NULL),
(71, 7, 0, 3, 1, 1, NULL, NULL),
(72, 7, 0, 4, 1, 1, NULL, NULL),
(73, 7, 0, 5, 1, 1, NULL, NULL),
(74, 7, 0, 6, 1, 1, NULL, NULL),
(75, 8, 0, 1, 1, 1, NULL, NULL),
(76, 8, 0, 2, 1, 1, NULL, NULL),
(77, 8, 0, 3, 1, 1, NULL, NULL),
(78, 8, 0, 4, 1, 1, NULL, NULL),
(79, 8, 0, 5, 1, 1, NULL, NULL),
(80, 8, 0, 6, 1, 1, NULL, NULL),
(81, 8, 0, 7, 1, 1, NULL, NULL),
(82, 8, 0, 8, 1, 1, NULL, NULL),
(83, 8, 0, 9, 1, 1, NULL, NULL),
(84, 8, 0, 10, 1, 1, NULL, NULL),
(85, 8, 0, 11, 1, 1, NULL, NULL),
(86, 8, 0, 12, 1, 1, NULL, NULL),
(87, 8, 0, 13, 1, 1, NULL, NULL),
(88, 8, 0, 14, 1, 1, NULL, NULL),
(89, 8, 0, 15, 1, 1, NULL, NULL),
(90, 8, 0, 16, 1, 1, NULL, NULL),
(91, 8, 0, 17, 1, 1, NULL, NULL),
(92, 8, 0, 18, 1, 1, NULL, NULL),
(93, 8, 0, 19, 1, 1, NULL, NULL),
(94, 8, 0, 20, 1, 1, NULL, NULL),
(95, 8, 0, 21, 1, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_category_description`
--

CREATE TABLE `[[dbprefix]]t_category_description` (
  `fk_i_category_id` int(10) unsigned NOT NULL,
  `fk_c_locale_code` char(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_description` text COLLATE utf8mb4_unicode_ci,
  `s_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`fk_i_category_id`,`fk_c_locale_code`),
  KEY `idx_s_slug` (`s_slug`),
  KEY `fk_c_locale_code` (`fk_c_locale_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_category_description`
--

INSERT INTO `[[dbprefix]]t_category_description` VALUES
(1, 'en_US', 'For sale', NULL, 'for-sale'),
(2, 'en_US', 'Vehicles', NULL, 'vehicles'),
(3, 'en_US', 'Classes', NULL, 'classes'),
(4, 'en_US', 'Real estate', NULL, 'real-estate'),
(5, 'en_US', 'Services', NULL, 'services'),
(6, 'en_US', 'Community', NULL, 'community'),
(7, 'en_US', 'Personals', NULL, 'personals'),
(8, 'en_US', 'Jobs', NULL, 'jobs'),
(9, 'en_US', 'Animals', NULL, 'animals'),
(10, 'en_US', 'Art - Collectibles', NULL, 'art-collectibles'),
(11, 'en_US', 'Barter', NULL, 'barter'),
(12, 'en_US', 'Books - Magazines', NULL, 'books-magazines'),
(13, 'en_US', 'Cameras - Camera Accessories', NULL, 'cameras-camera-accessories'),
(14, 'en_US', 'CDs - Records', NULL, 'cds-records'),
(15, 'en_US', 'Cell Phones - Accessories', NULL, 'cell-phones-accessories'),
(16, 'en_US', 'Clothing', NULL, 'clothing'),
(17, 'en_US', 'Computers - Hardware', NULL, 'computers-hardware'),
(18, 'en_US', 'DVD', NULL, 'dvd'),
(19, 'en_US', 'Electronics', NULL, 'electronics'),
(20, 'en_US', 'For Babies - Infants', NULL, 'for-babies-infants'),
(21, 'en_US', 'Garage Sale', NULL, 'garage-sale'),
(22, 'en_US', 'Health - Beauty', NULL, 'health-beauty'),
(23, 'en_US', 'Home - Furniture - Garden Supplies', NULL, 'home-furniture-garden-supplies'),
(24, 'en_US', 'Jewelry - Watches', NULL, 'jewelry-watches'),
(25, 'en_US', 'Musical Instruments', NULL, 'musical-instruments'),
(26, 'en_US', 'Sporting Goods - Bicycles', NULL, 'sporting-goods-bicycles'),
(27, 'en_US', 'Tickets', NULL, 'tickets'),
(28, 'en_US', 'Toys - Games - Hobbies', NULL, 'toys-games-hobbies'),
(29, 'en_US', 'Video Games - Consoles', NULL, 'video-games-consoles'),
(30, 'en_US', 'Everything Else', NULL, 'everything-else'),
(31, 'en_US', 'Cars', NULL, 'cars'),
(32, 'en_US', 'Car Parts', NULL, 'car-parts'),
(33, 'en_US', 'Motorcycles', NULL, 'motorcycles'),
(34, 'en_US', 'Boats - Ships', NULL, 'boats-ships'),
(35, 'en_US', 'RVs - Campers - Caravans', NULL, 'rvs-campers-caravans'),
(36, 'en_US', 'Trucks - Commercial Vehicles', NULL, 'trucks-commercial-vehicles'),
(37, 'en_US', 'Other Vehicles', NULL, 'other-vehicles'),
(38, 'en_US', 'Computer - Multimedia Classes', NULL, 'computer-multimedia-classes'),
(39, 'en_US', 'Language Classes', NULL, 'language-classes'),
(40, 'en_US', 'Music - Theatre - Dance Classes', NULL, 'music-theatre-dance-classes'),
(41, 'en_US', 'Tutoring - Private Lessons', NULL, 'tutoring-private-lessons'),
(42, 'en_US', 'Other Classes', NULL, 'other-classes'),
(43, 'en_US', 'Houses - Apartments for Sale', NULL, 'houses-apartments-for-sale'),
(44, 'en_US', 'Houses - Apartments for Rent', NULL, 'houses-apartments-for-rent'),
(45, 'en_US', 'Rooms for Rent - Shared', NULL, 'rooms-for-rent-shared'),
(46, 'en_US', 'Housing Swap', NULL, 'housing-swap'),
(47, 'en_US', 'Vacation Rentals', NULL, 'vacation-rentals'),
(48, 'en_US', 'Parking Spots', NULL, 'parking-spots'),
(49, 'en_US', 'Land', NULL, 'land'),
(50, 'en_US', 'Office - Commercial Space', NULL, 'office-commercial-space'),
(51, 'en_US', 'Shops for Rent - Sale', NULL, 'shops-for-rent-sale'),
(52, 'en_US', 'Babysitter - Nanny', NULL, 'babysitter-nanny'),
(53, 'en_US', 'Casting - Auditions', NULL, 'casting-auditions'),
(54, 'en_US', 'Computer', NULL, 'computer'),
(55, 'en_US', 'Event Services', NULL, 'event-services'),
(56, 'en_US', 'Health - Beauty - Fitness', NULL, 'health-beauty-fitness'),
(57, 'en_US', 'Horoscopes - Tarot', NULL, 'horoscopes-tarot'),
(58, 'en_US', 'Household - Domestic Help', NULL, 'household-domestic-help'),
(59, 'en_US', 'Moving - Storage', NULL, 'moving-storage'),
(60, 'en_US', 'Repair', NULL, 'repair'),
(61, 'en_US', 'Writing - Editing - Translating', NULL, 'writing-editing-translating'),
(62, 'en_US', 'Other Services', NULL, 'other-services'),
(63, 'en_US', 'Carpool', NULL, 'carpool'),
(64, 'en_US', 'Community Activities', NULL, 'community-activities'),
(65, 'en_US', 'Events', NULL, 'events'),
(66, 'en_US', 'Musicians - Artists - Bands', NULL, 'musicians-artists-bands'),
(67, 'en_US', 'Volunteers', NULL, 'volunteers'),
(68, 'en_US', 'Lost And Found', NULL, 'lost-and-found'),
(69, 'en_US', 'Women looking for Men', NULL, 'women-looking-for-men'),
(70, 'en_US', 'Men looking for Women', NULL, 'men-looking-for-women'),
(71, 'en_US', 'Men looking for Men', NULL, 'men-looking-for-men'),
(72, 'en_US', 'Women looking for Women', NULL, 'women-looking-for-women'),
(73, 'en_US', 'Friendship - Activity Partners', NULL, 'friendship-activity-partners'),
(74, 'en_US', 'Missed Connections', NULL, 'missed-connections'),
(75, 'en_US', 'Accounting - Finance', NULL, 'accounting-finance'),
(76, 'en_US', 'Advertising - Public Relations', NULL, 'advertising-public-relations'),
(77, 'en_US', 'Arts - Entertainment - Publishing', NULL, 'arts-entertainment-publishing'),
(78, 'en_US', 'Clerical - Administrative', NULL, 'clerical-administrative'),
(79, 'en_US', 'Customer Service', NULL, 'customer-service'),
(80, 'en_US', 'Education - Training', NULL, 'education-training'),
(81, 'en_US', 'Engineering - Architecture', NULL, 'engineering-architecture'),
(82, 'en_US', 'Healthcare', NULL, 'healthcare'),
(83, 'en_US', 'Human Resource', NULL, 'human-resource'),
(84, 'en_US', 'Internet', NULL, 'internet'),
(85, 'en_US', 'Legal', NULL, 'legal'),
(86, 'en_US', 'Manual Labor', NULL, 'manual-labor'),
(87, 'en_US', 'Manufacturing - Operations', NULL, 'manufacturing-operations'),
(88, 'en_US', 'Marketing', NULL, 'marketing'),
(89, 'en_US', 'Non-profit - Volunteer', NULL, 'non-profit-volunteer'),
(90, 'en_US', 'Real Estate', NULL, 'real-estate'),
(91, 'en_US', 'Restaurant - Food Service', NULL, 'restaurant-food-service'),
(92, 'en_US', 'Retail', NULL, 'retail'),
(93, 'en_US', 'Sales', NULL, 'sales'),
(94, 'en_US', 'Technology', NULL, 'technology'),
(95, 'en_US', 'Other Jobs', NULL, 'other-jobs');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_category_stats`
--

CREATE TABLE `[[dbprefix]]t_category_stats` (
  `fk_i_category_id` int(10) unsigned NOT NULL,
  `i_num_items` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fk_i_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_category_stats`
--

INSERT INTO `[[dbprefix]]t_category_stats` VALUES
(1, 1),
(9, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_city`
--

CREATE TABLE `[[dbprefix]]t_city` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_i_region_id` int(10) unsigned NOT NULL,
  `fk_c_country_code` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_slug` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `b_active` tinyint(1) NOT NULL DEFAULT '1',
  `d_coord_lat` decimal(20,10) DEFAULT NULL,
  `d_coord_long` decimal(20,10) DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_i_region_id` (`fk_i_region_id`),
  KEY `fk_c_country_code` (`fk_c_country_code`),
  KEY `idx_s_name` (`s_name`),
  KEY `idx_s_name_native` (`s_name_native`),
  KEY `idx_s_slug` (`s_slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_city_area`
--

CREATE TABLE `[[dbprefix]]t_city_area` (
  `pk_i_id` int(10) unsigned NOT NULL,
  `fk_i_city_id` int(10) unsigned NOT NULL,
  `fk_i_region_id` int(10) unsigned NOT NULL,
  `fk_c_country_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_slug` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `b_active` tinyint(1) NOT NULL DEFAULT '1',
  `d_coord_lat` decimal(20,10) DEFAULT NULL,
  `d_coord_long` decimal(20,10) DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_i_city_id` (`fk_i_city_id`),
  KEY `fk_i_region_id` (`fk_i_region_id`),
  KEY `fk_c_country_code` (`fk_c_country_code`),
  KEY `idx_s_name` (`s_name`),
  KEY `idx_s_name_native` (`s_name_native`),
  KEY `idx_s_slug` (`s_slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_city_stats`
--

CREATE TABLE `[[dbprefix]]t_city_stats` (
  `fk_i_city_id` int(10) unsigned NOT NULL,
  `i_num_items` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fk_i_city_id`),
  KEY `idx_num_items` (`i_num_items`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_country`
--

CREATE TABLE `[[dbprefix]]t_country` (
  `pk_c_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name_native` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_phone_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_slug` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`pk_c_code`),
  KEY `idx_s_slug` (`s_slug`),
  KEY `idx_s_name` (`s_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_country_stats`
--

CREATE TABLE `[[dbprefix]]t_country_stats` (
  `fk_c_country_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `i_num_items` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fk_c_country_code`),
  KEY `idx_num_items` (`i_num_items`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_cron`
--

CREATE TABLE `[[dbprefix]]t_cron` (
  `e_type` enum('INSTANT','MINUTELY','HOURLY','DAILY','WEEKLY','MONTHLY','YEARLY','CUSTOM') COLLATE utf8mb4_unicode_ci NOT NULL,
  `d_last_exec` datetime NOT NULL,
  `d_next_exec` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_cron`
--

INSERT INTO `[[dbprefix]]t_cron` VALUES
('MINUTELY', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('HOURLY', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('DAILY', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('WEEKLY', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('MONTHLY', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('YEARLY', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_currency`
--

CREATE TABLE `[[dbprefix]]t_currency` (
  `pk_c_code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_description` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pk_c_code`),
  UNIQUE KEY `s_name` (`s_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_currency`
--

INSERT INTO `[[dbprefix]]t_currency` VALUES
('EUR', 'European Union Euro', '€', 1),
('GBP', 'United Kingdom Pound', '£', 1),
('USD', 'United States Dollar', '$', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item`
--

CREATE TABLE `[[dbprefix]]t_item` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_i_user_id` int(10) unsigned DEFAULT NULL,
  `fk_i_category_id` int(10) unsigned NOT NULL,
  `dt_pub_date` datetime NOT NULL,
  `dt_mod_date` datetime DEFAULT NULL,
  `f_price` float DEFAULT NULL,
  `i_price` bigint(20) DEFAULT NULL,
  `fk_c_currency_code` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_contact_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_contact_email` varchar(140) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_contact_phone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_contact_other` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_ip` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `b_premium` tinyint(1) NOT NULL DEFAULT '0',
  `b_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `b_active` tinyint(1) NOT NULL DEFAULT '0',
  `b_spam` tinyint(1) NOT NULL DEFAULT '0',
  `s_secret` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_show_email` tinyint(1) DEFAULT NULL,
  `b_show_phone` tinyint(1) DEFAULT '1',
  `i_renewed` int(3) DEFAULT '0',
  `dt_expiration` datetime NOT NULL DEFAULT '9999-12-31 23:59:59',
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_i_user_id` (`fk_i_user_id`),
  KEY `idx_b_premium` (`b_premium`),
  KEY `idx_s_contact_email` (`s_contact_email`(10)),
  KEY `fk_i_category_id` (`fk_i_category_id`),
  KEY `fk_c_currency_code` (`fk_c_currency_code`),
  KEY `idx_pub_date` (`dt_pub_date`),
  KEY `idx_price` (`i_price`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]t_item`
--

INSERT INTO `[[dbprefix]]t_item` VALUES
(1, NULL, 9, '[[regtime]]', NULL, NULL, NULL, NULL, 'Example author', 'osclass@example.com', '', '', '[[clientip]]', 0, 1, 1, 0, '[[s_secret]]', 0, 0, 0, '9999-12-31 23:59:59');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item_comment`
--

CREATE TABLE `[[dbprefix]]t_item_comment` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_i_item_id` int(10) unsigned NOT NULL,
  `dt_pub_date` datetime NOT NULL,
  `s_title` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_author_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `i_rating` int(3) DEFAULT NULL,
  `b_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `b_active` tinyint(1) NOT NULL DEFAULT '0',
  `b_spam` tinyint(1) NOT NULL DEFAULT '0',
  `fk_i_user_id` int(10) unsigned DEFAULT NULL,
  `fk_i_reply_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_i_item_id` (`fk_i_item_id`),
  KEY `fk_i_user_id` (`fk_i_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item_description`
--

CREATE TABLE `[[dbprefix]]t_item_description` (
  `fk_i_item_id` int(10) unsigned NOT NULL,
  `fk_c_locale_code` char(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`fk_i_item_id`,`fk_c_locale_code`),
  FULLTEXT KEY `s_description` (`s_description`,`s_title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_item_description`
--

INSERT INTO `[[dbprefix]]t_item_description` VALUES
(1, 'en_US', 'Example Ad', 'Description of the example ad. Insert here some usefull description of your ad.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item_location`
--

CREATE TABLE `[[dbprefix]]t_item_location` (
  `fk_i_item_id` int(10) unsigned NOT NULL,
  `fk_c_country_code` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_country` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_country_native` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_zip` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_region_id` int(10) unsigned DEFAULT NULL,
  `s_region` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_region_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_city_id` int(10) unsigned DEFAULT NULL,
  `s_city` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_city_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_city_area_id` int(10) unsigned DEFAULT NULL,
  `s_city_area` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `d_coord_lat` decimal(20,10) DEFAULT NULL,
  `d_coord_long` decimal(20,10) DEFAULT NULL,
  PRIMARY KEY (`fk_i_item_id`),
  KEY `fk_c_country_code` (`fk_c_country_code`),
  KEY `fk_i_region_id` (`fk_i_region_id`),
  KEY `fk_i_city_id` (`fk_i_city_id`),
  KEY `fk_i_city_area_id` (`fk_i_city_area_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_item_location`
--

INSERT INTO `[[dbprefix]]t_item_location` VALUES
(1, NULL, 'Example country', '', '', NULL, NULL, 'Example region', NULL, NULL, 'Example city', NULL, NULL, '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item_meta`
--

CREATE TABLE `[[dbprefix]]t_item_meta` (
  `fk_i_item_id` int(10) unsigned NOT NULL,
  `fk_i_field_id` int(10) unsigned NOT NULL,
  `s_value` text COLLATE utf8mb4_unicode_ci,
  `s_multi` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`fk_i_item_id`,`fk_i_field_id`,`s_multi`),
  KEY `s_value` (`s_value`(255)),
  KEY `fk_i_field_id` (`fk_i_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item_resource`
--

CREATE TABLE `[[dbprefix]]t_item_resource` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_i_item_id` int(10) unsigned NOT NULL,
  `s_name` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_extension` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_content_type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `i_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_i_item_id` (`fk_i_item_id`),
  KEY `idx_s_content_type` (`pk_i_id`,`s_content_type`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_item_stats`
--

CREATE TABLE `[[dbprefix]]t_item_stats` (
  `fk_i_item_id` int(10) unsigned NOT NULL,
  `i_num_views` int(10) unsigned NOT NULL DEFAULT '0',
  `i_num_spam` int(10) unsigned NOT NULL DEFAULT '0',
  `i_num_repeated` int(10) unsigned NOT NULL DEFAULT '0',
  `i_num_bad_classified` int(10) unsigned NOT NULL DEFAULT '0',
  `i_num_offensive` int(10) unsigned NOT NULL DEFAULT '0',
  `i_num_expired` int(10) unsigned NOT NULL DEFAULT '0',
  `i_num_premium_views` int(10) unsigned NOT NULL DEFAULT '0',
  `dt_date` date NOT NULL,
  PRIMARY KEY (`fk_i_item_id`,`dt_date`),
  KEY `dt_date_fk_i_item_id` (`dt_date`,`fk_i_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_item_stats`
--

INSERT INTO `[[dbprefix]]t_item_stats` VALUES
(1, 0, 0, 0, 0, 0, 0, 0, '[[regdate]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_keywords`
--

CREATE TABLE `[[dbprefix]]t_keywords` (
  `s_md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fk_c_locale_code` char(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_original_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_anchor_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_normalized_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fk_i_category_id` int(10) unsigned DEFAULT NULL,
  `fk_i_city_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`s_md5`,`fk_c_locale_code`),
  KEY `fk_i_category_id` (`fk_i_category_id`),
  KEY `fk_i_city_id` (`fk_i_city_id`),
  KEY `fk_c_locale_code` (`fk_c_locale_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_latest_searches`
--

CREATE TABLE `[[dbprefix]]t_latest_searches` (
  `d_date` datetime NOT NULL,
  `s_search` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_locale`
--

CREATE TABLE `[[dbprefix]]t_locale` (
  `pk_c_code` char(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_short_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_description` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_version` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_author_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_author_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_currency_format` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_dec_point` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT '.',
  `s_thousands_sep` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `i_num_dec` tinyint(4) DEFAULT '2',
  `s_date_format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_stop_words` text COLLATE utf8mb4_unicode_ci,
  `b_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `b_enabled_bo` tinyint(1) NOT NULL DEFAULT '1',
  `b_locations_native` tinyint(1) DEFAULT '0',
  `b_rtl` tinyint(1) DEFAULT '0',
  `fk_c_currency_code` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`pk_c_code`),
  UNIQUE KEY `s_short_name` (`s_short_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_locale`
--

INSERT INTO `[[dbprefix]]t_locale` VALUES
('en_US', 'English (US)', 'English', 'American english translation', '8.3.0', 'OsclassPoint', 'https://osclass-classifieds.com/', '{NUMBER} {CURRENCY}', '.', '', 2, 'm/d/Y', 'i,a,about,an,are,as,at,be,by,com,for,from,how,in,is,it,of,on,or,that,the,this,to,was,what,when,where,who,will,with,the', 1, 1, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_locations_tmp`
--

CREATE TABLE `[[dbprefix]]t_locations_tmp` (
  `id_location` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `e_type` enum('COUNTRY','REGION','CITY') COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id_location`,`e_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_log`
--

CREATE TABLE `[[dbprefix]]t_log` (
  `dt_date` datetime NOT NULL,
  `s_section` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fk_i_id` int(10) unsigned NOT NULL,
  `s_data` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_detail` text COLLATE utf8mb4_unicode_ci,
  `s_comment` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_ip` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_who` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fk_i_who_id` int(10) unsigned NOT NULL,
  KEY `idx_s_section` (`s_section`),
  KEY `idx_s_action` (`s_action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_log`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_meta_categories`
--

CREATE TABLE `[[dbprefix]]t_meta_categories` (
  `fk_i_category_id` int(10) unsigned NOT NULL,
  `fk_i_field_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`fk_i_category_id`,`fk_i_field_id`),
  KEY `fk_i_field_id` (`fk_i_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_meta_fields`
--

CREATE TABLE `[[dbprefix]]t_meta_fields` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `s_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `e_type` enum('TEXT','NUMBER','TEL','EMAIL','COLOR','TEXTAREA','DROPDOWN','RADIO','CHECKBOX','URL','DATE','DATEINTERVAL') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TEXT',
  `s_options` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_required` tinyint(1) NOT NULL DEFAULT '0',
  `b_searchable` tinyint(1) NOT NULL DEFAULT '0',
  `i_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pk_i_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_pages`
--

CREATE TABLE `[[dbprefix]]t_pages` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `s_internal_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_indelible` tinyint(1) NOT NULL DEFAULT '0',
  `b_link` tinyint(1) NOT NULL DEFAULT '1',
  `b_index` tinyint(1) NOT NULL DEFAULT '1',
  `i_visibility` tinyint(1) DEFAULT '0',
  `dt_pub_date` datetime NOT NULL,
  `dt_mod_date` datetime DEFAULT NULL,
  `i_order` int(3) NOT NULL DEFAULT '0',
  `s_meta` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pk_i_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]t_pages`
--

INSERT INTO `[[dbprefix]]t_pages` VALUES
(1, 'email_item_inquiry', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(2, 'email_user_validation', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(3, 'email_user_registration', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(4, 'email_send_friend', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(5, 'alert_email_hourly', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(6, 'alert_email_daily', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(7, 'alert_email_weekly', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(8, 'alert_email_instant', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(9, 'email_new_comment_admin', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(10, 'email_new_item_non_register_user', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(11, 'email_item_validation', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(12, 'email_admin_new_item', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(13, 'email_user_forgot_password', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(14, 'email_new_email', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(15, 'email_alert_validation', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(16, 'email_comment_validated', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(17, 'email_item_validation_non_register_user', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(18, 'email_admin_new_user', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(19, 'email_contact_user', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(20, 'email_new_comment_user', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(21, 'email_new_admin', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(22, 'email_warn_expiration', 1, 1, 1, 0, '[[regtime]]', NULL, 0, NULL),
(23, 'example_page', 0, 0, 1, 0, '[[regtime]]', '[[regtime]]', 1, '""');


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_pages_description`
--

CREATE TABLE `[[dbprefix]]t_pages_description` (
  `fk_i_pages_id` int(10) unsigned NOT NULL,
  `fk_c_locale_code` char(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_text` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fk_i_pages_id`,`fk_c_locale_code`),
  KEY `fk_c_locale_code` (`fk_c_locale_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_pages_description`
--

INSERT INTO `[[dbprefix]]t_pages_description` VALUES
(1, 'en_US', '{WEB_TITLE} - Someone has a question about your listing', '<p>Hi {CONTACT_NAME}!</p><p>{USER_NAME} ({USER_EMAIL}, {USER_PHONE}) left you a message about your listing <a href="{ITEM_URL}">{ITEM_TITLE}</a>:</p><p>{COMMENT}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(2, 'en_US', 'Please validate your {WEB_TITLE} account', '<p>Hi {USER_NAME},</p><p>Please validate your registration by clicking on the following link: {VALIDATION_LINK}</p><p>Thank you!</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(3, 'en_US', '{WEB_TITLE} - Registration successful!', '<p>Hi {USER_NAME},</p><p>You''ve successfully registered for {WEB_LINK}.</p><p>Thank you!</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(4, 'en_US', 'Look at what I discovered on {WEB_TITLE}', '<p>Hi {FRIEND_NAME},</p><p>Your friend {USER_NAME} wants to share this listing with you <a href="{ITEM_URL}">{ITEM_TITLE}</a>.</p><p>Message:</p><p>{COMMENT}</p><p>Regards,</p><p>{WEB_TITLE}</p>'),
(5, 'en_US', '{WEB_TITLE} - New listings in the last hour', '<p>Hi {USER_NAME},</p><p>New listings have been published in the last hour. Take a look at them:</p><p>{ADS}</p><p><hr/></p><p>To unsubscribe from this alert, click on: {UNSUB_LINK}</p><p>{WEB_LINK}</p>'),
(6, 'en_US', '{WEB_TITLE} - New listings in the last day', '<p>Hi {USER_NAME},</p><p>New listings have been published in the last day. Take a look at them:</p><p>{ADS}</p><p><hr/></p><p>To unsubscribe from this alert, click on: {UNSUB_LINK}</p><p>{WEB_LINK}</p>'),
(7, 'en_US', '{WEB_TITLE} - New listings in the last week', '<p>Hi {USER_NAME},</p><p>New listings have been published in the last week. Take a look at them:</p><p>{ADS}</p><p><hr/></p><p>To unsubscribe from this alert, click on: {UNSUB_LINK}</p><p>{WEB_LINK}</p>'),
(8, 'en_US', '{WEB_TITLE} - New listings', '<p>Hi {USER_NAME},</p><p>A new listing has been published, check it out!</p><p>{ADS}</p><p><hr/></p><p>To unsubscribe from this alert, click on: {UNSUB_LINK}</p><p>{WEB_LINK}</p>'),
(9, 'en_US', '{WEB_TITLE} - New comment', '<p>Someone commented on the listing <a href="{ITEM_URL}">{ITEM_TITLE}</a>.</p><p>Commenter: {COMMENT_AUTHOR}<br />Commenter''s email: {COMMENT_EMAIL}<br />Title: {COMMENT_TITLE}<br />Comment: {COMMENT_TEXT}</p>'),
(10, 'en_US', '{WEB_TITLE} - Edit options for the listing {ITEM_TITLE}', '<p>Hi {USER_NAME},</p><p>You''re not registered at {WEB_LINK}, but you can still edit or delete the listing <a href="{ITEM_URL}">{ITEM_TITLE}</a> for a short period of time.</p><p>You can edit your listing by following this link: {EDIT_LINK}</p><p>You can delete your listing by following this link: {DELETE_LINK}</p><p>If you register as a user, you will have full access to editing options.</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(11, 'en_US', '{WEB_TITLE} - Validate your listing', '<p>Hi {USER_NAME},</p><p>You''re receiving this e-mail because a listing has been published at {WEB_LINK}. Please validate this listing by clicking on the following link: {VALIDATION_LINK}. If you didn''t publish this listing, please ignore this email.</p><p>Listing details:</p><p>Contact name: {USER_NAME}<br />Contact e-mail: {USER_EMAIL}</p><p>{ITEM_DESCRIPTION}</p><p>Url: {ITEM_URL}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(12, 'en_US', '{WEB_TITLE} - A new listing has been published', '<p>Dear {WEB_TITLE} admin,</p><p>You''re receiving this email because a listing has been published at {WEB_LINK}.</p><p>Listing details:</p><p>Contact name: {USER_NAME}<br />Contact email: {USER_EMAIL}</p><p>{ITEM_DESCRIPTION}</p><p>Url: {ITEM_URL}</p><p>You can edit this listing by clicking on the following link: {EDIT_LINK}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(13, 'en_US', '{WEB_TITLE} - Recover your password', '<p>Hi {USER_NAME},</p><p>We''ve sent you this e-mail because you''ve requested a password reminder. Follow this link to recover it: {PASSWORD_LINK}</p><p>The link will be deactivated in 24 hours.</p><p>If you didn''t request a password reminder, please ignore this message. This request was made from IP {IP_ADDRESS} on {DATE_TIME}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(14, 'en_US', '{WEB_TITLE} - You requested an email change', '<p>Hi {USER_NAME}</p><p>You''re receiving this e-mail because you requested an e-mail change. Please confirm this new e-mail address by clicking on the following validation link: {VALIDATION_LINK}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(15, 'en_US', '{WEB_TITLE} - Please validate your alert', '<p>Hi {USER_NAME},</p><p>Please validate your alert registration by clicking on the following link: {VALIDATION_LINK}</p><p>Thank you!</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(16, 'en_US', '{WEB_TITLE} - Your comment has been approved', '<p>Hi {COMMENT_AUTHOR},</p><p>Your comment on <a href="{ITEM_URL}">{ITEM_TITLE}</a> has been approved.</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(17, 'en_US', '{WEB_TITLE} - Validate your listing', '<p>Hi {USER_NAME},</p><p>You''re receiving this e-mail because you’ve published a listing at {WEB_LINK}. Please validate this listing by clicking on the following link: {VALIDATION_LINK}. If you didn''t publish this listing, please ignore this e-mail.</p><p>Listing details:</p><p>Contact name: {USER_NAME}<br />Contact e-mail: {USER_EMAIL}</p><p>{ITEM_DESCRIPTION}</p><p>Url: {ITEM_URL}</p><p>Even if you''re not registered at {WEB_LINK}, you can still edit or delete your listing:</p><p>You can edit your listing by following this link: {EDIT_LINK}</p><p>You can delete your listing by following this link: {DELETE_LINK}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(18, 'en_US', '{WEB_TITLE} - A new user has registered', '<p>Dear {WEB_TITLE} admin,</p><p>You''re receiving this email because a new user has been created at {WEB_LINK}.</p><p>User details:</p><p>Name: {USER_NAME}<br />E-mail: {USER_EMAIL}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(19, 'en_US', '{WEB_TITLE} - Someone has a question for you', '<p>Hi {CONTACT_NAME}!</p><p>{USER_NAME} ({USER_EMAIL}, {USER_PHONE}) left you a message:</p><p>{COMMENT}</p><p>Regards,</p><p>{WEB_LINK}</p>'),
(20, 'en_US', '{WEB_TITLE} - Someone has commented on your listing', '<p>There''s a new comment on the listing: <a href="{ITEM_URL}">{ITEM_TITLE}</a>.</p><p>Author: {COMMENT_AUTHOR}<br />Author''s email: {COMMENT_EMAIL}<br />Title: {COMMENT_TITLE}<br />Comment: {COMMENT_TEXT}</p><p>{WEB_LINK}</p>'),
(21, 'en_US', '{WEB_TITLE} - Success creating admin account!', '<p>Hi {ADMIN_NAME},</p><p>The admin of {WEB_LINK} has created an account for you,</p><ul><li>Username: {USERNAME}</li><li>Password: {PASSWORD}</li></ul><p>You can access the admin panel here {WEB_ADMIN_LINK}.</p><p>Thank you!</p><p>Regards,</p>'),
(22, 'en_US', '{WEB_TITLE} - Your ad is about to expire', '<p>Hi {USER_NAME},</p><p>Your listing <a href="{ITEM_URL}">{ITEM_TITLE}</a> is about to expire at {WEB_LINK}.'),
(23, 'en_US', 'Example page title', 'This is an example page description. This is a good place to put your Terms of Service or any other help information.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_plugin_category`
--

CREATE TABLE `[[dbprefix]]t_plugin_category` (
  `s_plugin_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fk_i_category_id` int(10) unsigned NOT NULL,
  KEY `fk_i_category_id` (`fk_i_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_preference`
--

CREATE TABLE `[[dbprefix]]t_preference` (
  `s_section` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `e_type` enum('STRING','INTEGER','BOOLEAN') COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `s_section` (`s_section`,`s_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]t_preference`
--

INSERT INTO `[[dbprefix]]t_preference` VALUES
('osclass', 'active_plugins', '', 'STRING'),
('osclass', 'admin_color_scheme', '', 'STRING'),
('osclass', 'admin_language', 'en_US', 'STRING'),
('osclass', 'admin_theme', 'omega', 'STRING'),
('osclass', 'admin_toolbar_front', '0', 'BOOLEAN'),
('osclass', 'admindash_columns_hidden', '', 'STRING'),
('osclass', 'admindash_widgets_collapsed', '', 'STRING'),
('osclass', 'admindash_widgets_hidden', '', 'STRING'),
('osclass', 'akismetKey', '', 'STRING'),
('osclass', 'allow_report_osclass', '0', 'BOOLEAN'),
('osclass', 'allowedExt', 'png,gif,jpg,jpeg', 'STRING'),
('osclass', 'always_gen_canonical', '1', 'BOOLEAN'),
('osclass', 'auto_cron', '1', 'BOOLEAN'),
('osclass', 'auto_update', 'disabled', 'STRING'),
('osclass', 'best_fit_image', '1', 'BOOLEAN'),
('osclass', 'breadcrumbs_hide', '', 'STRING'),
('osclass', 'breadcrumbs_hide_custom', '', 'STRING'),
('osclass', 'breadcrumbs_item_category', '1', 'BOOLEAN'),
('osclass', 'breadcrumbs_item_city', '0', 'BOOLEAN'),
('osclass', 'breadcrumbs_item_country', '0', 'BOOLEAN'),
('osclass', 'breadcrumbs_item_page_title', '1', 'BOOLEAN'),
('osclass', 'breadcrumbs_item_parent_categories', '0', 'BOOLEAN'),
('osclass', 'breadcrumbs_item_region', '0', 'BOOLEAN'),
('osclass', 'can_deactivate_items', '0', 'BOOLEAN'),
('osclass', 'canvas_background', 'white', 'STRING'),
('osclass', 'comment_rating_limit', '1', 'INTEGER'),
('osclass', 'comment_reply_user_type', '', 'STRING'),
('osclass', 'comments_per_page', '10', 'INTEGER'),
('osclass', 'contact_attachment', '0', 'BOOLEAN'),
('osclass', 'contactEmail', '[[admin_email]]', 'STRING'),
('osclass', 'csrf_name', '[[csrf_name]]', 'STRING'),
('osclass', 'css_banned_pages', 'item-item_add,item-item_edit', 'STRING'),
('osclass', 'css_banned_words', 'font,awesome,tiny,fineuploader', 'STRING'),
('osclass', 'css_merge', '0', 'BOOLEAN'),
('osclass', 'css_minify', '0', 'BOOLEAN'),
('osclass', 'currency', 'USD', 'STRING'),
('osclass', 'custom_css', '', 'STRING'),
('osclass', 'custom_css_hook', '', 'STRING'),
('osclass', 'custom_html', '', 'STRING'),
('osclass', 'custom_html_hook', '', 'STRING'),
('osclass', 'custom_js', '', 'STRING'),
('osclass', 'custom_js_hook', '', 'STRING'),
('osclass', 'dateFormat', 'Y/m/d', 'STRING'),
('osclass', 'defaultOrderField@search', 'dt_pub_date', 'STRING'),
('osclass', 'defaultOrderType@search', '1', 'BOOLEAN'),
('osclass', 'defaultResultsPerPage@search', '12', 'INTEGER'),
('osclass', 'defaultShowAs@search', 'list', 'STRING'),
('osclass', 'description_character_length', '5000', 'INTEGER'),
('osclass', 'dimNormal', '640x480', 'STRING'),
('osclass', 'dimPreview', '480x340', 'STRING'),
('osclass', 'dimProfileImg', '180x180', 'STRING'),
('osclass', 'dimThumbnail', '240x200', 'STRING'),
('osclass', 'enable_comment_rating', '0', 'BOOLEAN'),
('osclass', 'enable_comment_reply', '1', 'BOOLEAN'),
('osclass', 'enable_comment_reply_rating', '1', 'BOOLEAN'),
('osclass', 'enable_profile_img', '1', 'BOOLEAN'),
('osclass', 'enable_rss', '1', 'BOOLEAN'),
('osclass', 'enabled_comments', '1', 'BOOLEAN'),
('osclass', 'enabled_recaptcha_items', '0', 'BOOLEAN'),
('osclass', 'enabled_renewal_items', '0', 'BOOLEAN'),
('osclass', 'enabled_tinymce_items', '0', 'BOOLEAN'),
('osclass', 'enabled_tinymce_users', '0', 'BOOLEAN'),
('osclass', 'enabled_user_registration', '1', 'BOOLEAN'),
('osclass', 'enabled_user_validation', '1', 'BOOLEAN'),
('osclass', 'enabled_users', '1', 'BOOLEAN'),
('osclass', 'enableField#f_price@items', '1', 'BOOLEAN'),
('osclass', 'enableField#images@items', '1', 'BOOLEAN'),
('osclass', 'enhance_canonical_url_enabled', '1', 'BOOLEAN'),
('osclass', 'force_aspect_image', '0', 'BOOLEAN'),
('osclass', 'gen_hreflang_tags', '0', 'BOOLEAN'),
('osclass', 'hide_generator', '0', 'BOOLEAN'),
('osclass', 'image_upload_lib_force_replace', '1', 'BOOLEAN'),
('osclass', 'image_upload_library', 'UPPY', 'STRING'),
('osclass', 'image_upload_reorder', '1', 'BOOLEAN'),
('osclass', 'installed_plugins', '', 'STRING'),
('osclass', 'item_attachment', '0', 'BOOLEAN'),
('osclass', 'item_contact_form_disabled', '0', 'BOOLEAN'),
('osclass', 'item_mark_disable', '0', 'BOOLEAN'),
('osclass', 'item_post_redirect', '', 'STRING'),
('osclass', 'item_send_friend_form_disabled', '0', 'BOOLEAN'),
('osclass', 'item_stats_method', 'SESSION', 'STRING'),
('osclass', 'items_wait_time', '0', 'INTEGER'),
('osclass', 'jquery_version', '3', 'STRING'),
('osclass', 'js_banned_pages', 'item-item_add,item-item_edit', 'STRING'),
('osclass', 'js_banned_words', 'tiny,fineuploader', 'STRING'),
('osclass', 'js_merge', '0', 'BOOLEAN'),
('osclass', 'js_minify', '0', 'BOOLEAN'),
('osclass', 'keep_original_image', '1', 'BOOLEAN'),
('osclass', 'language', 'en_US', 'STRING'),
('osclass', 'last_version_check', '', 'STRING'),
('osclass', 'latest_searches_restriction', '0', 'INTEGER'),
('osclass', 'latest_searches_words', '', 'STRING'),
('osclass', 'locale_to_base_url_enabled', '0', 'BOOLEAN'),
('osclass', 'locale_to_base_url_type', '', 'STRING'),
('osclass', 'logged_user_item_validation', '1', 'BOOLEAN'),
('osclass', 'logging_auto_cleanup', '0', 'BOOLEAN'),
('osclass', 'logging_enabled', '1', 'BOOLEAN'),
('osclass', 'logging_months', '24', 'INTEGER'),
('osclass', 'mailserver_auth', '', 'BOOLEAN'),
('osclass', 'mailserver_host', 'localhost', 'STRING'),
('osclass', 'mailserver_mail_from', '', 'STRING'),
('osclass', 'mailserver_name_from', '', 'STRING'),
('osclass', 'mailserver_password', '', 'STRING'),
('osclass', 'mailserver_pop', '', 'BOOLEAN'),
('osclass', 'mailserver_port', '', 'INTEGER'),
('osclass', 'mailserver_ssl', '', 'STRING'),
('osclass', 'mailserver_type', 'custom', 'STRING'),
('osclass', 'mailserver_username', '', 'STRING'),
('osclass', 'market_products_version', '', 'STRING'),
('osclass', 'maxLatestItems@home', '12', 'INTEGER'),
('osclass', 'maxResultsPerPage@search', '50', 'INTEGER'),
('osclass', 'maxSizeKb', '4096', 'INTEGER'),
('osclass', 'mod_rewrite_loaded', '0', 'BOOLEAN'),
('osclass', 'moderate_comments', '0', 'INTEGER'),
('osclass', 'moderate_items', '-1', 'INTEGER'),
('osclass', 'notify_contact_friends', '1', 'BOOLEAN'),
('osclass', 'notify_contact_item', '1', 'BOOLEAN'),
('osclass', 'notify_new_comment', '1', 'BOOLEAN'),
('osclass', 'notify_new_comment_reply', '0', 'BOOLEAN'),
('osclass', 'notify_new_comment_reply_user', '0', 'BOOLEAN'),
('osclass', 'notify_new_comment_user', '0', 'BOOLEAN'),
('osclass', 'notify_new_item', '1', 'BOOLEAN'),
('osclass', 'notify_new_user', '1', 'BOOLEAN'),
('osclass', 'num_category_levels', '4', 'INTEGER'),
('osclass', 'num_rss_items', '50', 'INTEGER'),
('osclass', 'numImages@items', '4', 'INTEGER'),
('osclass', 'optimize_uploaded_images', '1', 'BOOLEAN'),
('osclass', 'osclass_installed', '1', 'BOOLEAN'),
('osclass', 'osclasspoint_api_key', '', 'STRING'),
('osclass', 'pageDesc', '', 'STRING'),
('osclass', 'pageTitle', '[[site_name]]', 'STRING'),
('osclass', 'ping_search_engines', '0', 'BOOLEAN'),
('osclass', 'profile_picture_library', 'UPPY', 'STRING'),
('osclass', 'purge_latest_searches', '1000', 'STRING'),
('osclass', 'recaptcha_version', '2', 'STRING'),
('osclass', 'recaptchaEnabled', '0', 'BOOLEAN'),
('osclass', 'recaptchaPrivKey', '', 'STRING'),
('osclass', 'recaptchaPubKey', '', 'STRING'),
('osclass', 'reg_user_can_contact', '0', 'BOOLEAN'),
('osclass', 'reg_user_can_see_phone', '0', 'BOOLEAN'),
('osclass', 'reg_user_post', '0', 'BOOLEAN'),
('osclass', 'reg_user_post_comments', '0', 'BOOLEAN'),
('osclass', 'regenerate_image_data', '', 'STRING'),
('osclass', 'renewal_limit', '0', 'INTEGER'),
('osclass', 'renewal_update_pub_date', '0', 'BOOLEAN'),
('osclass', 'rewrite_cat_url', '{CATEGORIES}', 'STRING'),
('osclass', 'rewrite_contact', 'contact', 'STRING'),
('osclass', 'rewrite_feed', 'feed', 'STRING'),
('osclass', 'rewrite_item_activate', 'item/activate', 'STRING'),
('osclass', 'rewrite_item_contact', 'item/contact', 'STRING'),
('osclass', 'rewrite_item_deactivate', 'item/deactivate', 'STRING'),
('osclass', 'rewrite_item_delete', 'item/delete', 'STRING'),
('osclass', 'rewrite_item_edit', 'item/edit', 'STRING'),
('osclass', 'rewrite_item_mark', 'item/mark', 'STRING'),
('osclass', 'rewrite_item_new', 'item/new', 'STRING'),
('osclass', 'rewrite_item_renew', 'item/renew', 'STRING'),
('osclass', 'rewrite_item_resource_delete', 'resource/delete', 'STRING'),
('osclass', 'rewrite_item_send_friend', 'item/send-friend', 'STRING'),
('osclass', 'rewrite_item_url', '{CATEGORIES}/{ITEM_TITLE}-i{ITEM_ID}', 'STRING'),
('osclass', 'rewrite_language', 'language', 'STRING'),
('osclass', 'rewrite_page_url', '{PAGE_SLUG}-p{PAGE_ID}', 'STRING'),
('osclass', 'rewrite_rules', '', 'STRING'),
('osclass', 'rewrite_search_category', 'category', 'STRING'),
('osclass', 'rewrite_search_city', 'city', 'STRING'),
('osclass', 'rewrite_search_city_area', 'cityarea', 'STRING'),
('osclass', 'rewrite_search_country', 'country', 'STRING'),
('osclass', 'rewrite_search_custom_rules_enabled', '0', 'BOOLEAN'),
('osclass', 'rewrite_search_custom_rules_strict', '1', 'BOOLEAN'),
('osclass', 'rewrite_search_order', 'order', 'STRING'),
('osclass', 'rewrite_search_order_by_expiration', 'expiration', 'STRING'),
('osclass', 'rewrite_search_order_by_price', 'price', 'STRING'),
('osclass', 'rewrite_search_order_by_pub_date', 'pub-date', 'STRING'),
('osclass', 'rewrite_search_order_by_rating', 'rating', 'STRING'),
('osclass', 'rewrite_search_order_by_relevance', 'relevance', 'STRING'),
('osclass', 'rewrite_search_order_type', 'sort', 'STRING'),
('osclass', 'rewrite_search_page_number', 'pn', 'STRING'),
('osclass', 'rewrite_search_pattern', 'pattern', 'STRING'),
('osclass', 'rewrite_search_premium_only', 'premium-only', 'STRING'),
('osclass', 'rewrite_search_price_max', 'price-max', 'STRING'),
('osclass', 'rewrite_search_price_min', 'price-min', 'STRING'),
('osclass', 'rewrite_search_region', 'region', 'STRING'),
('osclass', 'rewrite_search_show_as', 'view', 'STRING'),
('osclass', 'rewrite_search_url', 'search', 'STRING'),
('osclass', 'rewrite_search_user', 'user', 'STRING'),
('osclass', 'rewrite_search_with_phone', 'with-phone', 'STRING'),
('osclass', 'rewrite_search_with_picture', 'with-picture', 'STRING'),
('osclass', 'rewrite_user_activate', 'user/activate', 'STRING'),
('osclass', 'rewrite_user_activate_alert', 'alert/confirm', 'STRING'),
('osclass', 'rewrite_user_alerts', 'user/alerts', 'STRING'),
('osclass', 'rewrite_user_change_email', 'email/change', 'STRING'),
('osclass', 'rewrite_user_change_email_confirm', 'email/confirm', 'STRING'),
('osclass', 'rewrite_user_change_password', 'password/change', 'STRING'),
('osclass', 'rewrite_user_change_username', 'username/change', 'STRING'),
('osclass', 'rewrite_user_dashboard', 'user/dashboard', 'STRING'),
('osclass', 'rewrite_user_forgot', 'user/forgot', 'STRING'),
('osclass', 'rewrite_user_items', 'user/items', 'STRING'),
('osclass', 'rewrite_user_login', 'user/login', 'STRING'),
('osclass', 'rewrite_user_logout', 'user/logout', 'STRING'),
('osclass', 'rewrite_user_profile', 'user/profile', 'STRING'),
('osclass', 'rewrite_user_recover', 'user/recover', 'STRING'),
('osclass', 'rewrite_user_register', 'user/register', 'STRING'),
('osclass', 'rewriteEnabled', '0', 'BOOLEAN'),
('osclass', 'save_latest_searches', '0', 'BOOLEAN'),
('osclass', 'search_pattern_method', '', 'STRING'),
('osclass', 'selectable_parent_categories', '0', 'BOOLEAN'),
('osclass', 'seo_url_search_prefix', '', 'STRING'),
('osclass', 'structured_data', '0', 'BOOLEAN'),
('osclass', 'subdomain_host', '', 'STRING'),
('osclass', 'subdomain_landing', '0', 'BOOLEAN'),
('osclass', 'subdomain_language_slug_type', '', 'STRING'),
('osclass', 'subdomain_redirect', '0', 'BOOLEAN'),
('osclass', 'subdomain_restricted_ids', '', 'STRING'),
('osclass', 'subdomain_type', '', 'STRING'),
('osclass', 'theme', 'sigma', 'STRING'),
('osclass', 'timeFormat', 'H:i', 'STRING'),
('osclass', 'timezone', 'Europe/Madrid', 'STRING'),
('osclass', 'title_character_length', '100', 'INTEGER'),
('osclass', 'update_core_json', '', 'STRING'),
('osclass', 'update_include_occontent', '0', 'BOOLEAN'),
('osclass', 'use_imagick', '0', 'BOOLEAN'),
('osclass', 'user_public_profile_enabled', 'ALL', 'STRING'),
('osclass', 'user_public_profile_min_items', '0', 'INTEGER'),
('osclass', 'username_blacklist', 'admin,user', 'STRING'),
('osclass', 'username_generator', 'ID', 'STRING'),
('osclass', 'version', '830', 'INTEGER'),
('osclass', 'warn_expiration', '0', 'INTEGER'),
('osclass', 'watermark_image', '', 'STRING'),
('osclass', 'watermark_place', 'centre', 'STRING'),
('osclass', 'watermark_text', '', 'STRING'),
('osclass', 'watermark_text_color', '', 'STRING'),
('osclass', 'web_contact_form_disabled', '0', 'BOOLEAN'),
('osclass', 'weekStart', '0', 'STRING'),
('osclass', 'widget_data_api', '', 'STRING'),
('osclass', 'widget_data_blog', '', 'STRING'),
('osclass', 'widget_data_product', '', 'STRING'),
('osclass', 'widget_data_product_updates', '', 'STRING'),
('osclass', 'widget_data_update', '', 'STRING'),
('sigma', 'defaultLocationShowAs', 'dropdown', 'STRING'),
('sigma', 'defaultShowAs@all', 'list', 'STRING'),
('sigma', 'donation', '0', 'STRING'),
('sigma', 'footer_link', '1', 'STRING'),
('sigma', 'keyword_placeholder', 'ie. PHP Programmer', 'STRING'),
('sigma', 'logo', 'sigma_logo.png', 'STRING'),
('sigma', 'rtl', '0', 'STRING'),
('sigma', 'version', '150', 'STRING');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_region`
--

CREATE TABLE `[[dbprefix]]t_region` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_c_country_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_name_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_slug` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `b_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pk_i_id`),
  KEY `fk_c_country_code` (`fk_c_country_code`),
  KEY `idx_s_name` (`s_name`),
  KEY `idx_s_name_native` (`s_name_native`),
  KEY `idx_s_slug` (`s_slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_region_stats`
--

CREATE TABLE `[[dbprefix]]t_region_stats` (
  `fk_i_region_id` int(10) unsigned NOT NULL,
  `i_num_items` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fk_i_region_id`),
  KEY `idx_num_items` (`i_num_items`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_site`
--

CREATE TABLE `[[dbprefix]]t_site` (
  `s_site` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_site_mapping` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_user_id` int(10) unsigned DEFAULT NULL,
  `s_db_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_db_host` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_db_user` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_db_password` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_upload_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dt_date` datetime DEFAULT NULL,
  PRIMARY KEY (`s_site`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_user`
--

CREATE TABLE `[[dbprefix]]t_user` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dt_reg_date` datetime NOT NULL,
  `dt_mod_date` datetime DEFAULT NULL,
  `s_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_password` char(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_secret` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_website` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_phone_land` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_phone_mobile` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `b_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `b_active` tinyint(1) NOT NULL DEFAULT '0',
  `s_pass_code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_pass_date` datetime DEFAULT NULL,
  `s_pass_ip` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_c_country_code` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_country` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_country_native` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_zip` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_region_id` int(10) unsigned DEFAULT NULL,
  `s_region` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_region_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_city_id` int(10) unsigned DEFAULT NULL,
  `s_city` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `s_city_native` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_i_city_area_id` int(10) unsigned DEFAULT NULL,
  `s_city_area` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `d_coord_lat` decimal(20,10) DEFAULT NULL,
  `d_coord_long` decimal(20,10) DEFAULT NULL,
  `b_company` tinyint(1) NOT NULL DEFAULT '0',
  `i_items` int(10) unsigned DEFAULT '0',
  `i_comments` int(10) unsigned DEFAULT '0',
  `dt_access_date` datetime DEFAULT NULL,
  `s_access_ip` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `i_login_fails` int(3) DEFAULT '0',
  `dt_login_fail_date` datetime DEFAULT NULL,
  `s_profile_img` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fk_c_locale_code` char(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`pk_i_id`),
  UNIQUE KEY `s_email` (`s_email`),
  KEY `idx_s_name` (`s_name`(6)),
  KEY `idx_s_username` (`s_username`),
  KEY `fk_c_country_code` (`fk_c_country_code`),
  KEY `fk_i_region_id` (`fk_i_region_id`),
  KEY `fk_i_city_id` (`fk_i_city_id`),
  KEY `fk_i_city_area_id` (`fk_i_city_area_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_user_description`
--

CREATE TABLE `[[dbprefix]]t_user_description` (
  `fk_i_user_id` int(10) unsigned NOT NULL,
  `fk_c_locale_code` char(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fk_i_user_id`,`fk_c_locale_code`),
  KEY `fk_c_locale_code` (`fk_c_locale_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_user_email_tmp`
--

CREATE TABLE `[[dbprefix]]t_user_email_tmp` (
  `fk_i_user_id` int(10) unsigned NOT NULL,
  `s_new_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dt_date` datetime NOT NULL,
  PRIMARY KEY (`fk_i_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]t_widget`
--

CREATE TABLE `[[dbprefix]]t_widget` (
  `pk_i_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `s_description` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_location` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `e_kind` enum('TEXT','HTML') COLLATE utf8mb4_unicode_ci NOT NULL,
  `s_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`pk_i_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]t_category`
--
ALTER TABLE `[[dbprefix]]t_category`
  ADD CONSTRAINT `[[dbprefix]]t_category_ibfk_1` FOREIGN KEY (`fk_i_parent_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_category_description`
--
ALTER TABLE `[[dbprefix]]t_category_description`
  ADD CONSTRAINT `[[dbprefix]]t_category_description_ibfk_1` FOREIGN KEY (`fk_i_category_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_category_description_ibfk_2` FOREIGN KEY (`fk_c_locale_code`) REFERENCES `[[dbprefix]]t_locale` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_category_stats`
--
ALTER TABLE `[[dbprefix]]t_category_stats`
  ADD CONSTRAINT `[[dbprefix]]t_category_stats_ibfk_1` FOREIGN KEY (`fk_i_category_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_city`
--
ALTER TABLE `[[dbprefix]]t_city`
  ADD CONSTRAINT `[[dbprefix]]t_city_ibfk_1` FOREIGN KEY (`fk_i_region_id`) REFERENCES `[[dbprefix]]t_region` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_city_ibfk_2` FOREIGN KEY (`fk_c_country_code`) REFERENCES `[[dbprefix]]t_country` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_city_area`
--
ALTER TABLE `[[dbprefix]]t_city_area`
  ADD CONSTRAINT `[[dbprefix]]t_city_area_ibfk_1` FOREIGN KEY (`fk_i_city_id`) REFERENCES `[[dbprefix]]t_city` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_city_area_ibfk_2` FOREIGN KEY (`fk_i_region_id`) REFERENCES `[[dbprefix]]t_region` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_city_area_ibfk_3` FOREIGN KEY (`fk_c_country_code`) REFERENCES `[[dbprefix]]t_country` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_city_stats`
--
ALTER TABLE `[[dbprefix]]t_city_stats`
  ADD CONSTRAINT `[[dbprefix]]t_city_stats_ibfk_1` FOREIGN KEY (`fk_i_city_id`) REFERENCES `[[dbprefix]]t_city` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_country_stats`
--
ALTER TABLE `[[dbprefix]]t_country_stats`
  ADD CONSTRAINT `[[dbprefix]]t_country_stats_ibfk_1` FOREIGN KEY (`fk_c_country_code`) REFERENCES `[[dbprefix]]t_country` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_item`
--
ALTER TABLE `[[dbprefix]]t_item`
  ADD CONSTRAINT `[[dbprefix]]t_item_ibfk_1` FOREIGN KEY (`fk_i_user_id`) REFERENCES `[[dbprefix]]t_user` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_ibfk_2` FOREIGN KEY (`fk_i_category_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_ibfk_3` FOREIGN KEY (`fk_c_currency_code`) REFERENCES `[[dbprefix]]t_currency` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_item_comment`
--
ALTER TABLE `[[dbprefix]]t_item_comment`
  ADD CONSTRAINT `[[dbprefix]]t_item_comment_ibfk_1` FOREIGN KEY (`fk_i_item_id`) REFERENCES `[[dbprefix]]t_item` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_comment_ibfk_2` FOREIGN KEY (`fk_i_user_id`) REFERENCES `[[dbprefix]]t_user` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_item_location`
--
ALTER TABLE `[[dbprefix]]t_item_location`
  ADD CONSTRAINT `[[dbprefix]]t_item_location_ibfk_1` FOREIGN KEY (`fk_i_item_id`) REFERENCES `[[dbprefix]]t_item` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_location_ibfk_2` FOREIGN KEY (`fk_c_country_code`) REFERENCES `[[dbprefix]]t_country` (`pk_c_code`),
  ADD CONSTRAINT `[[dbprefix]]t_item_location_ibfk_3` FOREIGN KEY (`fk_i_region_id`) REFERENCES `[[dbprefix]]t_region` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_location_ibfk_4` FOREIGN KEY (`fk_i_city_id`) REFERENCES `[[dbprefix]]t_city` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_location_ibfk_5` FOREIGN KEY (`fk_i_city_area_id`) REFERENCES `[[dbprefix]]t_city_area` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_item_meta`
--
ALTER TABLE `[[dbprefix]]t_item_meta`
  ADD CONSTRAINT `[[dbprefix]]t_item_meta_ibfk_1` FOREIGN KEY (`fk_i_item_id`) REFERENCES `[[dbprefix]]t_item` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_item_meta_ibfk_2` FOREIGN KEY (`fk_i_field_id`) REFERENCES `[[dbprefix]]t_meta_fields` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_item_resource`
--
ALTER TABLE `[[dbprefix]]t_item_resource`
  ADD CONSTRAINT `[[dbprefix]]t_item_resource_ibfk_1` FOREIGN KEY (`fk_i_item_id`) REFERENCES `[[dbprefix]]t_item` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_item_stats`
--
ALTER TABLE `[[dbprefix]]t_item_stats`
  ADD CONSTRAINT `[[dbprefix]]t_item_stats_ibfk_1` FOREIGN KEY (`fk_i_item_id`) REFERENCES `[[dbprefix]]t_item` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_keywords`
--
ALTER TABLE `[[dbprefix]]t_keywords`
  ADD CONSTRAINT `[[dbprefix]]t_keywords_ibfk_1` FOREIGN KEY (`fk_i_category_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_keywords_ibfk_2` FOREIGN KEY (`fk_i_city_id`) REFERENCES `[[dbprefix]]t_city` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_keywords_ibfk_3` FOREIGN KEY (`fk_c_locale_code`) REFERENCES `[[dbprefix]]t_locale` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_meta_categories`
--
ALTER TABLE `[[dbprefix]]t_meta_categories`
  ADD CONSTRAINT `[[dbprefix]]t_meta_categories_ibfk_1` FOREIGN KEY (`fk_i_category_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_meta_categories_ibfk_2` FOREIGN KEY (`fk_i_field_id`) REFERENCES `[[dbprefix]]t_meta_fields` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_pages_description`
--
ALTER TABLE `[[dbprefix]]t_pages_description`
  ADD CONSTRAINT `[[dbprefix]]t_pages_description_ibfk_1` FOREIGN KEY (`fk_i_pages_id`) REFERENCES `[[dbprefix]]t_pages` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_pages_description_ibfk_2` FOREIGN KEY (`fk_c_locale_code`) REFERENCES `[[dbprefix]]t_locale` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_plugin_category`
--
ALTER TABLE `[[dbprefix]]t_plugin_category`
  ADD CONSTRAINT `[[dbprefix]]t_plugin_category_ibfk_1` FOREIGN KEY (`fk_i_category_id`) REFERENCES `[[dbprefix]]t_category` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_region`
--
ALTER TABLE `[[dbprefix]]t_region`
  ADD CONSTRAINT `[[dbprefix]]t_region_ibfk_1` FOREIGN KEY (`fk_c_country_code`) REFERENCES `[[dbprefix]]t_country` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_region_stats`
--
ALTER TABLE `[[dbprefix]]t_region_stats`
  ADD CONSTRAINT `[[dbprefix]]t_region_stats_ibfk_1` FOREIGN KEY (`fk_i_region_id`) REFERENCES `[[dbprefix]]t_region` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_user`
--
ALTER TABLE `[[dbprefix]]t_user`
  ADD CONSTRAINT `[[dbprefix]]t_user_ibfk_1` FOREIGN KEY (`fk_c_country_code`) REFERENCES `[[dbprefix]]t_country` (`pk_c_code`),
  ADD CONSTRAINT `[[dbprefix]]t_user_ibfk_2` FOREIGN KEY (`fk_i_region_id`) REFERENCES `[[dbprefix]]t_region` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_user_ibfk_3` FOREIGN KEY (`fk_i_city_id`) REFERENCES `[[dbprefix]]t_city` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_user_ibfk_4` FOREIGN KEY (`fk_i_city_area_id`) REFERENCES `[[dbprefix]]t_city_area` (`pk_i_id`);

--
-- Constraints for table `[[dbprefix]]t_user_description`
--
ALTER TABLE `[[dbprefix]]t_user_description`
  ADD CONSTRAINT `[[dbprefix]]t_user_description_ibfk_1` FOREIGN KEY (`fk_i_user_id`) REFERENCES `[[dbprefix]]t_user` (`pk_i_id`),
  ADD CONSTRAINT `[[dbprefix]]t_user_description_ibfk_2` FOREIGN KEY (`fk_c_locale_code`) REFERENCES `[[dbprefix]]t_locale` (`pk_c_code`);

--
-- Constraints for table `[[dbprefix]]t_user_email_tmp`
--
ALTER TABLE `[[dbprefix]]t_user_email_tmp`
  ADD CONSTRAINT `[[dbprefix]]t_user_email_tmp_ibfk_1` FOREIGN KEY (`fk_i_user_id`) REFERENCES `[[dbprefix]]t_user` (`pk_i_id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
