<?php

/**
 * @package tikiwiki
 */

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
$section = 'mytiki';
require_once('tiki-setup.php');
$inputConfiguration = [
    [
        'staticKeyFilters'         => [
        'showall'                  => 'bool',            //get
        'view_user'                => 'usename',         //post
        'uselib'                   => 'bool',            //post
        'avatar'                   => 'none',            //get
        'reset'                    => 'bool',            //post
        ],
    ],
];
$userprefslib = TikiLib::lib('userprefs');
$access->check_feature('feature_userPreferences');
$access->check_user($user);
$auto_query_args = ['view_user'];
if (! isset($_REQUEST["showall"])) {
    $_REQUEST["showall"] = 'n';
}
$smarty->assign('showall', $_REQUEST["showall"]);
$userwatch = $user;
if (isset($_REQUEST["view_user"])) {
    if ($_REQUEST["view_user"] <> $user) {
        if ($tiki_p_admin == 'y') {
            $userwatch = $_REQUEST["view_user"];
        } else {
            $smarty->assign('errortype', 401);
            $smarty->assign('msg', tra("You do not have permission to view other users data"));
            $smarty->display("error.tpl");
            die;
        }
    } else {
        $userwatch = $user;
    }
}
$smarty->assign('userwatch', $userwatch);
// Upload avatar is processed here
if (isset($_FILES['userfile1'])) {
    if (is_uploaded_file($_FILES['userfile1']['tmp_name'])) {
        $access->checkCsrf();
        $name = $_FILES['userfile1']['name'];

        $filegallib = TikiLib::lib('filegal');
        try {
            $filegallib->assertUploadedFileIsSafe($_FILES['userfile1']['tmp_name'], $_FILES['userfile1']['name']);
        } catch (Exception $e) {
            $smarty->assign('errortype', 403);
            $smarty->assign('msg', $e->getMessage());
            $smarty->display("error.tpl");
            die;
        }

        $avatarlib = TikiLib::lib('avatar');
        $avatarlib->set_avatar_from_url($_FILES['userfile1']['tmp_name'], $userwatch, $name);

        /* redirect to prevent re-submit on page reload */
        if ($tiki_p_admin == 'y' && $user !== $userwatch) {
            header('Location: tiki-pick_avatar.php?view_user=' . $userwatch);
        } else {
            header('Location: tiki-pick_avatar.php');
        }
        exit;
    } else {
        Feedback::error($tikilib->uploaded_file_error($_FILES['userfile1']['error']));
    }
}

if (isset($_REQUEST["uselib"])) {
    $access->checkCsrf();
    $userprefslib->set_user_avatar($userwatch, 'l', $_REQUEST["avatar"], '', '', '', '');
}
if (isset($_REQUEST["reset"])) {
    $access->checkCsrf();
    $userprefslib->set_user_avatar($userwatch, '0', '', '', '', '', '');
    $userprefslib->remove_file_gallery_image($userwatch);
}
$avatars = [];
$h = opendir("img/avatars/");
while ($file = readdir($h)) {
    if ($file != '.' && $file != '..' && $file != 'index.php' && substr($file, 0, 1) != "." && $file != "CVS" && $file != "README") {
        $avatars[] = 'img/avatars/' . $file;
    }
}
closedir($h);
$smarty->assign_by_ref('avatars', $avatars);
$smarty->assign('numav', count($avatars));
$smarty->assign('yours', mt_rand(0, count($avatars)));

$avatar = $tikilib->get_user_avatar($userwatch);
$smarty->assign('avatar', $avatar);

// Get full user picture if it is set
if ($prefs["user_store_file_gallery_picture"] == 'y' && $user_picture_id = $userprefslib->get_user_picture_id($userwatch)) {
    $smarty->assign('user_picture_id', $user_picture_id);
}

include_once('tiki-mytiki_shared.php');
$smarty->assign('mid', 'tiki-pick_avatar.tpl');
$smarty->display("tiki.tpl");
