<?php

declare(strict_types=1);

namespace LaminasTest\Log;

use Laminas\Log\PsrLoggerAbstractAdapterFactory;
use Laminas\Log\PsrLoggerAdapter;
use Laminas\ServiceManager\Config;
use Laminas\ServiceManager\Exception\ServiceNotFoundException;
use Laminas\ServiceManager\ServiceLocatorInterface;
use Laminas\ServiceManager\ServiceManager;
use PHPUnit\Framework\TestCase;

class PsrLoggerAbstractAdapterFactoryTest extends TestCase
{
    /** @var ServiceLocatorInterface */
    protected $serviceManager;

    /**
     * Set up LoggerAbstractServiceFactory and loggers configuration.
     */
    protected function setUp(): void
    {
        $this->serviceManager = new ServiceManager();
        $config               = new Config([
            'abstract_factories' => [PsrLoggerAbstractAdapterFactory::class],
            'services'           => [
                'config' => [
                    'psr_log' => [
                        'Application\Frontend' => [],
                        'Application\Backend'  => [],
                    ],
                ],
            ],
        ]);
        $config->configureServiceManager($this->serviceManager);
    }

    /**
     * @return array
     */
    public function providerValidLoggerService()
    {
        return [
            ['Application\Frontend'],
            ['Application\Backend'],
        ];
    }

    /**
     * @return array
     */
    public function providerInvalidLoggerService()
    {
        return [
            ['Logger\Application\Unknown'],
            ['Logger\Application\Frontend'],
            ['Application\Backend\Logger'],
        ];
    }

    /**
     * @param string $service
     * @dataProvider providerValidLoggerService
     */
    public function testValidLoggerService($service): void
    {
        $actual = $this->serviceManager->get($service);
        $this->assertInstanceOf(PsrLoggerAdapter::class, $actual);
    }

    /**
     * @dataProvider providerInvalidLoggerService
     * @param string $service
     */
    public function testInvalidLoggerService($service): void
    {
        $this->expectException(ServiceNotFoundException::class);
        $this->serviceManager->get($service);
    }
}
