/*
 * Copyright (c) 2025, Tribal Limited
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Zenario, Tribal Limited nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL TRIBAL LTD BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

zenario.lib(function(
	undefined,
	URLBasePath,
	document, window, windowOpener, windowParent,
	zenario, zenarioA, zenarioT, zenarioAB, zenarioAT, zenarioO,
	encodeURIComponent, defined, engToBoolean, get, htmlspecialchars, jsEscape, phrase,
	extensionOf, methodsOf, has,
	panelTypes
) {
	"use strict";

var methods = methodsOf(
	panelTypes.start_page = extensionOf(panelTypes.base)
);


methods.init = function() {
	//...
};

//You should return the page size you wish to use, or false to disable pagination
methods.returnPageSize = function() {
	return false;
};



//Use this to add any requests you need to the AJAX URL used to call your panel
methods.returnAJAXRequests = function() {
	return {
		fromCID: zenarioA.fromCID,
		fromCType: zenarioA.fromCType
	};
};


methods.returnPanelTitle = function() {
	return zenarioO.panelProp('title');
};

methods.showPanel = function($header, $panel, $footer) {
	
	//Get all of the merge fields we'll need to draw this panel
	var m = {
		//Include the array of WIP links generated in our fillOrganizerPanel() method
		wip_content_links: thus.tuix.wip_content_links || [],
		//Include the array of enabled content types
		enabled_content_types: thus.tuix.enabled_content_types || [],
	};
	
	//Get the HTML for this panel from the "start page" microtemplate
	var html = thus.microTemplate('zenario_organizer_start_page', m);
	
	//Display it in the panel.
	$panel.html(html).show();
	
	
	//Disable some things that aren't used
	
	//The start page does not use the header area
	$header.html('').hide();
	
	//The start page does not use the footer area
	$footer.html('').hide();
};

//The start page does not use the buttons area
methods.showButtons = function($buttons) {
	$buttons.html('').hide();
};


}, zenarioO.panelTypes);